/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.PayloadTooLargeException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageReaderArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<HttpMessageReader<?>> messageReaders;

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> readers) {
        this(readers, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> messageReaders, ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
        Assert.notEmpty(messageReaders, (String)"At least one HttpMessageReader is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.messageReaders = messageReaders;
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    protected Mono<Object> readBody(MethodParameter bodyParameter, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange2) {
        return this.readBody(bodyParameter, null, isBodyRequired, bindingContext, exchange2);
    }

    protected Mono<Object> readBody(MethodParameter bodyParam, @Nullable MethodParameter actualParam, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange2) {
        MediaType contentType;
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParam);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter((MethodParameter)actualParam) : bodyType;
        Class resolvedType = bodyType.resolve();
        ReactiveAdapter adapter = resolvedType != null ? this.getAdapterRegistry().getAdapter(resolvedType) : null;
        ResolvableType elementType = adapter != null ? bodyType.getGeneric(new int[0]) : bodyType;
        isBodyRequired = isBodyRequired || adapter != null && !adapter.supportsEmpty();
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpHeaders headers = request.getHeaders();
        try {
            contentType = headers.getContentType();
        }
        catch (InvalidMediaTypeException ex2) {
            throw new UnsupportedMediaTypeStatusException("Can't parse Content-Type [" + headers.getFirst("Content-Type") + "]: " + ex2.getMessage(), this.getSupportedMediaTypes(elementType));
        }
        MediaType mediaType = contentType != null ? contentType : MediaType.APPLICATION_OCTET_STREAM;
        Object[] hints = this.extractValidationHints(bodyParam);
        if (mediaType.isCompatibleWith(MediaType.APPLICATION_FORM_URLENCODED)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Form data is accessed via ServerWebExchange.getFormData() in WebFlux.");
            }
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(exchange2.getLogPrefix() + (contentType != null ? "Content-Type:" + String.valueOf(contentType) : "No Content-Type, using " + String.valueOf(MediaType.APPLICATION_OCTET_STREAM))));
        }
        for (HttpMessageReader<?> reader : this.getMessageReaders()) {
            if (!reader.canRead(elementType, mediaType)) continue;
            Map readHints = Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)exchange2.getLogPrefix());
            if (adapter != null && adapter.isMultiValue()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(exchange2.getLogPrefix() + "0..N [" + String.valueOf(elementType) + "]"));
                }
                Flux flux = reader.read(actualType, elementType, request, response, readHints);
                flux = flux.onErrorMap(ex -> this.handleReadError(bodyParam, (Throwable)ex));
                if (isBodyRequired) {
                    flux = flux.switchIfEmpty((Publisher)Flux.error(() -> this.handleMissingBody(bodyParam)));
                }
                if (hints != null) {
                    flux = flux.doOnNext(target -> this.validate(target, hints, bodyParam, bindingContext, exchange2));
                }
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange2.getLogPrefix() + "0..1 [" + String.valueOf(elementType) + "]"));
            }
            Mono mono = reader.readMono(actualType, elementType, request, response, readHints);
            mono = mono.onErrorMap(ex -> this.handleReadError(bodyParam, (Throwable)ex));
            if (isBodyRequired) {
                mono = mono.switchIfEmpty(Mono.error(() -> this.handleMissingBody(bodyParam)));
            }
            if (hints != null) {
                mono = mono.doOnNext(target -> this.validate(target, hints, bodyParam, bindingContext, exchange2));
            }
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)mono)) : Mono.from((Publisher)mono);
        }
        HttpMethod method = request.getMethod();
        if (contentType == null && SUPPORTED_METHODS.contains(method)) {
            Flux body2 = request.getBody().doOnNext(buffer -> {
                DataBufferUtils.release((DataBuffer)buffer);
                throw new UnsupportedMediaTypeStatusException(mediaType, this.getSupportedMediaTypes(elementType), elementType);
            });
            if (isBodyRequired) {
                body2 = body2.switchIfEmpty((Publisher)Mono.error(() -> this.handleMissingBody(bodyParam)));
            }
            return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)body2)) : Mono.from((Publisher)body2);
        }
        return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(mediaType, this.getSupportedMediaTypes(elementType), elementType));
    }

    private Throwable handleReadError(MethodParameter parameter, Throwable ex) {
        if (ex instanceof DataBufferLimitException) {
            return new PayloadTooLargeException(ex);
        }
        if (ex instanceof DecodingException) {
            return new ServerWebInputException("Failed to read HTTP message", parameter, ex);
        }
        return ex;
    }

    private ServerWebInputException handleMissingBody(MethodParameter parameter) {
        DecodingException cause = new DecodingException("No request body for: " + parameter.getExecutable().toGenericString());
        ServerWebInputException ex = new ServerWebInputException("No request body", parameter, (Throwable)cause);
        ex.setDetail("Invalid request content");
        return ex;
    }

    private Object @Nullable [] extractValidationHints(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] hints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
            if (hints == null) continue;
            return hints;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(Object target, Object[] validationHints, MethodParameter parameter, BindingContext binding, ServerWebExchange exchange2) {
        String name = Conventions.getVariableNameForParameter((MethodParameter)parameter);
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
        WebExchangeDataBinder binder = binding.createDataBinder(exchange2, target, name, type);
        try {
            LocaleContextHolder.setLocaleContext((LocaleContext)exchange2.getLocaleContext());
            binder.validate(validationHints);
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
        if (binder.getBindingResult().hasErrors()) {
            throw new WebExchangeBindException(parameter, binder.getBindingResult());
        }
    }

    private List<MediaType> getSupportedMediaTypes(ResolvableType elementType) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (HttpMessageReader<?> reader : this.messageReaders) {
            mediaTypes.addAll(reader.getReadableMediaTypes(elementType));
        }
        return mediaTypes;
    }
}

