/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.DefaultClientResponseBuilder;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ClientResponse {
    public HttpStatusCode statusCode();

    public Headers headers();

    public MultiValueMap<String, ResponseCookie> cookies();

    public ExchangeStrategies strategies();

    public HttpRequest request();

    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> var1);

    public <T> Mono<T> bodyToMono(Class<? extends T> var1);

    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> var1);

    public <T> Flux<T> bodyToFlux(Class<? extends T> var1);

    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> var1);

    public Mono<Void> releaseBody();

    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> var1);

    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> var1);

    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> var1);

    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> var1);

    public Mono<ResponseEntity<Void>> toBodilessEntity();

    public Mono<WebClientResponseException> createException();

    public <T> Mono<T> createError();

    public String logPrefix();

    default public Builder mutate() {
        return new DefaultClientResponseBuilder(this, true);
    }

    public static Builder create(HttpStatusCode statusCode) {
        return ClientResponse.create(statusCode, ExchangeStrategies.withDefaults());
    }

    public static Builder create(HttpStatusCode statusCode, ExchangeStrategies strategies) {
        return new DefaultClientResponseBuilder(strategies).statusCode(statusCode);
    }

    public static Builder create(int statusCode, ExchangeStrategies strategies) {
        return new DefaultClientResponseBuilder(strategies).rawStatusCode(statusCode);
    }

    public static Builder create(HttpStatusCode statusCode, final List<HttpMessageReader<?>> messageReaders) {
        return ClientResponse.create(statusCode, new ExchangeStrategies(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return messageReaders;
            }

            @Override
            public List<HttpMessageWriter<?>> messageWriters() {
                return Collections.emptyList();
            }
        });
    }

    public static interface Builder {
        public Builder statusCode(HttpStatusCode var1);

        public Builder rawStatusCode(int var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder cookie(String var1, String ... var2);

        public Builder cookies(Consumer<MultiValueMap<String, ResponseCookie>> var1);

        public Builder body(Function<Flux<DataBuffer>, Flux<DataBuffer>> var1);

        public Builder body(Flux<DataBuffer> var1);

        public Builder body(String var1);

        public Builder request(HttpRequest var1);

        public ClientResponse build();
    }

    public static interface Headers {
        public OptionalLong contentLength();

        public Optional<MediaType> contentType();

        public List<String> header(String var1);

        public HttpHeaders asHttpHeaders();
    }
}

