/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client.support;

import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClientResponseWrapper
implements ClientResponse {
    private final ClientResponse delegate;

    public ClientResponseWrapper(ClientResponse delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate is required");
        this.delegate = delegate;
    }

    public ClientResponse response() {
        return this.delegate;
    }

    @Override
    public HttpStatusCode statusCode() {
        return this.delegate.statusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.delegate.headers();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> cookies() {
        return this.delegate.cookies();
    }

    @Override
    public ExchangeStrategies strategies() {
        return this.delegate.strategies();
    }

    @Override
    public HttpRequest request() {
        return this.delegate.request();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        return this.delegate.body(extractor);
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.delegate.bodyToMono(elementClass);
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
        return this.delegate.bodyToMono(elementTypeRef);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.delegate.bodyToFlux(elementClass);
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
        return this.delegate.bodyToFlux(elementTypeRef);
    }

    @Override
    public Mono<Void> releaseBody() {
        return this.delegate.releaseBody();
    }

    @Override
    public Mono<ResponseEntity<Void>> toBodilessEntity() {
        return this.delegate.toBodilessEntity();
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
        return this.delegate.toEntity(bodyType);
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeReference) {
        return this.delegate.toEntity(bodyTypeReference);
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
        return this.delegate.toEntityList(elementClass);
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
        return this.delegate.toEntityList(elementTypeRef);
    }

    @Override
    public Mono<WebClientResponseException> createException() {
        return this.delegate.createException();
    }

    @Override
    public <T> Mono<T> createError() {
        return this.delegate.createError();
    }

    @Override
    public String logPrefix() {
        return this.delegate.logPrefix();
    }

    public static class HeadersWrapper
    implements ClientResponse.Headers {
        private final ClientResponse.Headers headers;

        public HeadersWrapper(ClientResponse.Headers headers) {
            this.headers = headers;
        }

        @Override
        public OptionalLong contentLength() {
            return this.headers.contentLength();
        }

        @Override
        public Optional<MediaType> contentType() {
            return this.headers.contentType();
        }

        @Override
        public List<String> header(String headerName) {
            return this.headers.header(headerName);
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.headers.asHttpHeaders();
        }
    }
}

