/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.AbstractResourceResolver;
import org.springframework.web.reactive.resource.EncodedResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CachingResourceResolver
extends AbstractResourceResolver {
    public static final String RESOLVED_RESOURCE_CACHE_KEY_PREFIX = "resolvedResource:";
    public static final String RESOLVED_URL_PATH_CACHE_KEY_PREFIX = "resolvedUrlPath:";
    private final Cache cache;
    private final List<String> contentCodings = new ArrayList<String>(EncodedResourceResolver.DEFAULT_CODINGS);

    public CachingResourceResolver(Cache cache) {
        Assert.notNull((Object)cache, (String)"Cache is required");
        this.cache = cache;
    }

    public CachingResourceResolver(CacheManager cacheManager, String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("Cache '" + cacheName + "' not found");
        }
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setContentCodings(List<String> codings) {
        Assert.notEmpty(codings, (String)"At least one content coding expected");
        this.contentCodings.clear();
        this.contentCodings.addAll(codings);
    }

    public List<String> getContentCodings() {
        return Collections.unmodifiableList(this.contentCodings);
    }

    @Override
    protected Mono<Resource> resolveResourceInternal(@Nullable ServerWebExchange exchange2, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = this.computeKey(exchange2, requestPath);
        Resource cachedResource = (Resource)this.cache.get((Object)key, Resource.class);
        if (cachedResource != null) {
            String logPrefix = exchange2 != null ? exchange2.getLogPrefix() : "";
            this.logger.trace((Object)(logPrefix + "Resource resolved from cache"));
            return Mono.just((Object)cachedResource);
        }
        return chain.resolveResource(exchange2, requestPath, locations).doOnNext(resource2 -> this.cache.put((Object)key, resource2));
    }

    protected String computeKey(@Nullable ServerWebExchange exchange2, String requestPath) {
        String codingKey;
        if (exchange2 != null && StringUtils.hasText((String)(codingKey = this.getContentCodingKey(exchange2)))) {
            return RESOLVED_RESOURCE_CACHE_KEY_PREFIX + requestPath + "+encoding=" + codingKey;
        }
        return RESOLVED_RESOURCE_CACHE_KEY_PREFIX + requestPath;
    }

    @Nullable
    private String getContentCodingKey(ServerWebExchange exchange2) {
        String header = exchange2.getRequest().getHeaders().getFirst("Accept-Encoding");
        if (!StringUtils.hasText((String)header)) {
            return null;
        }
        return Arrays.stream(StringUtils.tokenizeToStringArray((String)header, (String)",")).map(token -> {
            int index = token.indexOf(59);
            return (index >= 0 ? token.substring(0, index) : token).trim().toLowerCase();
        }).filter(this.contentCodings::contains).sorted().collect(Collectors.joining(","));
    }

    @Override
    protected Mono<String> resolveUrlPathInternal(String resourceUrlPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        String key = RESOLVED_URL_PATH_CACHE_KEY_PREFIX + resourceUrlPath;
        String cachedUrlPath = (String)this.cache.get((Object)key, String.class);
        if (cachedUrlPath != null) {
            this.logger.trace((Object)"Path resolved from cache");
            return Mono.just((Object)cachedUrlPath);
        }
        return chain.resolveUrlPath(resourceUrlPath, locations).doOnNext(resolvedPath -> this.cache.put((Object)key, resolvedPath));
    }
}

