/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.reactivestreams.Subscriber;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketSession;

public class StandardWebSocketHandlerAdapter
extends Endpoint {
    private final WebSocketHandler delegateHandler;
    private Function<Session, StandardWebSocketSession> sessionFactory;
    @Nullable
    private StandardWebSocketSession delegateSession;

    public StandardWebSocketHandlerAdapter(WebSocketHandler handler, Function<Session, StandardWebSocketSession> sessionFactory) {
        Assert.notNull((Object)handler, (String)"WebSocketHandler is required");
        Assert.notNull(sessionFactory, (String)"'sessionFactory' is required");
        this.delegateHandler = handler;
        this.sessionFactory = sessionFactory;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.delegateSession = this.sessionFactory.apply(session);
        Assert.state((this.delegateSession != null ? 1 : 0) != 0, (String)"No delegate session");
        session.addMessageHandler(String.class, message -> {
            WebSocketMessage webSocketMessage = this.toMessage(message);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        });
        session.addMessageHandler(ByteBuffer.class, message -> {
            WebSocketMessage webSocketMessage = this.toMessage(message);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        });
        session.addMessageHandler(PongMessage.class, message -> {
            WebSocketMessage webSocketMessage = this.toMessage(message);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        });
        this.delegateHandler.handle(this.delegateSession).checkpoint(session.getRequestURI() + " [StandardWebSocketHandlerAdapter]").subscribe((Subscriber)this.delegateSession);
    }

    private <T> WebSocketMessage toMessage(T message) {
        StandardWebSocketSession session = this.delegateSession;
        Assert.state((session != null ? 1 : 0) != 0, (String)"Cannot create message without a session");
        if (message instanceof String) {
            byte[] bytes = ((String)message).getBytes(StandardCharsets.UTF_8);
            return new WebSocketMessage(WebSocketMessage.Type.TEXT, session.bufferFactory().wrap(bytes));
        }
        if (message instanceof ByteBuffer) {
            DataBuffer buffer = session.bufferFactory().wrap((ByteBuffer)message);
            return new WebSocketMessage(WebSocketMessage.Type.BINARY, buffer);
        }
        if (message instanceof PongMessage) {
            DataBuffer buffer = session.bufferFactory().wrap(((PongMessage)message).getApplicationData());
            return new WebSocketMessage(WebSocketMessage.Type.PONG, buffer);
        }
        throw new IllegalArgumentException("Unexpected message type: " + message);
    }

    public void onClose(Session session, CloseReason reason) {
        if (this.delegateSession != null) {
            int code = reason.getCloseCode().getCode();
            this.delegateSession.handleClose(new CloseStatus(code, reason.getReasonPhrase()));
        }
    }

    public void onError(Session session, Throwable exception) {
        if (this.delegateSession != null) {
            this.delegateSession.handleError(exception);
        }
    }
}

