/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class UrlHandlerFilter
implements WebFilter {
    private static final Log logger = LogFactory.getLog(UrlHandlerFilter.class);
    private final MultiValueMap<Handler, PathPattern> handlers;

    private UrlHandlerFilter(MultiValueMap<Handler, PathPattern> handlers) {
        this.handlers = new LinkedMultiValueMap(handlers);
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        RequestPath path = exchange2.getRequest().getPath();
        for (Map.Entry entry : this.handlers.entrySet()) {
            if (!((Handler)entry.getKey()).supports(exchange2)) continue;
            for (PathPattern pattern : (List)entry.getValue()) {
                if (!pattern.matches(path)) continue;
                return ((Handler)entry.getKey()).handle(exchange2, chain);
            }
        }
        return chain.filter(exchange2);
    }

    public static Builder.TrailingSlashSpec trailingSlashHandler(String ... pathPatterns) {
        return new DefaultBuilder().trailingSlashHandler(pathPatterns);
    }

    private static interface Handler {
        public boolean supports(ServerWebExchange var1);

        public Mono<Void> handle(ServerWebExchange var1, WebFilterChain var2);
    }

    private static final class DefaultBuilder
    implements Builder {
        private final PathPatternParser patternParser = new PathPatternParser();
        private final MultiValueMap<Handler, PathPattern> handlers = new LinkedMultiValueMap();

        private DefaultBuilder() {
        }

        @Override
        public Builder.TrailingSlashSpec trailingSlashHandler(String ... patterns) {
            return new DefaultTrailingSlashSpec(patterns);
        }

        private DefaultBuilder addHandler(List<PathPattern> pathPatterns, Handler handler) {
            pathPatterns.forEach(pattern -> this.handlers.add((Object)handler, pattern));
            return this;
        }

        @Override
        public UrlHandlerFilter build() {
            return new UrlHandlerFilter(this.handlers);
        }

        private final class DefaultTrailingSlashSpec
        implements Builder.TrailingSlashSpec {
            private final List<PathPattern> pathPatterns;
            private @Nullable List<Function<ServerHttpRequest, Mono<Void>>> interceptors;

            private DefaultTrailingSlashSpec(String[] patterns) {
                this.pathPatterns = Arrays.stream(patterns).map(pattern -> pattern.endsWith("**") || pattern.endsWith("/") ? pattern : pattern + "/").map(DefaultBuilder.this.patternParser::parse).toList();
            }

            @Override
            public Builder.TrailingSlashSpec intercept(Function<ServerHttpRequest, Mono<Void>> interceptor) {
                this.interceptors = this.interceptors != null ? this.interceptors : new ArrayList<Function<ServerHttpRequest, Mono<Void>>>();
                this.interceptors.add(interceptor);
                return this;
            }

            @Override
            public Builder redirect(HttpStatusCode statusCode) {
                RedirectTrailingSlashHandler handler = new RedirectTrailingSlashHandler(statusCode, this.interceptors);
                return DefaultBuilder.this.addHandler(this.pathPatterns, handler);
            }

            @Override
            public Builder mutateRequest() {
                RequestWrappingTrailingSlashHandler handler = new RequestWrappingTrailingSlashHandler(this.interceptors);
                return DefaultBuilder.this.addHandler(this.pathPatterns, handler);
            }
        }
    }

    public static interface Builder {
        public TrailingSlashSpec trailingSlashHandler(String ... var1);

        public UrlHandlerFilter build();

        public static interface TrailingSlashSpec {
            public TrailingSlashSpec intercept(Function<ServerHttpRequest, Mono<Void>> var1);

            public Builder redirect(HttpStatusCode var1);

            public Builder mutateRequest();
        }
    }

    private static final class RequestWrappingTrailingSlashHandler
    extends AbstractTrailingSlashHandler {
        RequestWrappingTrailingSlashHandler(@Nullable List<Function<ServerHttpRequest, Mono<Void>>> interceptors) {
            super(interceptors);
        }

        @Override
        public Mono<Void> handleInternal(ServerWebExchange exchange2, WebFilterChain chain) {
            ServerHttpRequest request = exchange2.getRequest();
            ServerHttpRequest mutatedRequest = request.mutate().path(this.trimTrailingSlash(request)).build();
            return chain.filter(exchange2.mutate().request(mutatedRequest).build());
        }
    }

    private static final class RedirectTrailingSlashHandler
    extends AbstractTrailingSlashHandler {
        private final HttpStatusCode statusCode;

        RedirectTrailingSlashHandler(HttpStatusCode statusCode, @Nullable List<Function<ServerHttpRequest, Mono<Void>>> interceptors) {
            super(interceptors);
            this.statusCode = statusCode;
        }

        @Override
        public Mono<Void> handleInternal(ServerWebExchange exchange2, WebFilterChain chain) {
            ServerHttpResponse response = exchange2.getResponse();
            response.setStatusCode(this.statusCode);
            response.getHeaders().set("Location", this.trimTrailingSlash(exchange2.getRequest()));
            return Mono.empty();
        }
    }

    private static abstract class AbstractTrailingSlashHandler
    implements Handler {
        private static final List<Function<ServerHttpRequest, Mono<Void>>> defaultInterceptors = List.of(request -> {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Handling trailing slash URL: " + String.valueOf(request.getMethod()) + " " + String.valueOf(request.getURI())));
            }
            return Mono.empty();
        });
        private final List<Function<ServerHttpRequest, Mono<Void>>> interceptors;

        protected AbstractTrailingSlashHandler(@Nullable List<Function<ServerHttpRequest, Mono<Void>>> interceptors) {
            this.interceptors = interceptors != null ? new ArrayList<Function<ServerHttpRequest, Mono<Void>>>(interceptors) : defaultInterceptors;
        }

        @Override
        public boolean supports(ServerWebExchange exchange2) {
            ServerHttpRequest request = exchange2.getRequest();
            List<PathContainer.Element> elements = request.getPath().pathWithinApplication().elements();
            return elements.size() > 1 && elements.get(elements.size() - 1).value().equals("/");
        }

        @Override
        public Mono<Void> handle(ServerWebExchange exchange2, WebFilterChain chain) {
            ArrayList monos = new ArrayList(this.interceptors.size());
            this.interceptors.forEach(interceptor -> monos.add((Mono)interceptor.apply(exchange2.getRequest())));
            return Flux.concat(monos).then(Mono.defer(() -> this.handleInternal(exchange2, chain)));
        }

        protected abstract Mono<Void> handleInternal(ServerWebExchange var1, WebFilterChain var2);

        protected String trimTrailingSlash(ServerHttpRequest request) {
            String path = request.getURI().getRawPath();
            int index = StringUtils.hasLength((String)path) ? path.lastIndexOf(47) : -1;
            return index != -1 ? path.substring(0, index) : path;
        }
    }
}

