/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractSmartHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractKotlinSerializationHttpMessageConverter<T extends SerialFormat>
extends AbstractSmartHttpMessageConverter<Object> {
    private final Map<KType, KSerializer<Object>> kTypeSerializerCache = new ConcurrentReferenceHashMap();
    private final Map<Type, KSerializer<Object>> typeSerializerCache = new ConcurrentReferenceHashMap();
    private final T format;

    protected AbstractKotlinSerializationHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.format = format;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        return this.getSupportedMediaTypes();
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return this.serializer(ResolvableType.forClass(clazz), null) != null;
    }

    @Override
    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        if (!ResolvableType.NONE.equals((Object)type) && this.serializer(type, null) != null) {
            return this.canRead(mediaType);
        }
        return false;
    }

    @Override
    public boolean canWrite(ResolvableType type, Class<?> clazz, @Nullable MediaType mediaType) {
        if (!ResolvableType.NONE.equals((Object)type) && this.serializer(type, null) != null) {
            return this.canWrite(mediaType);
        }
        return false;
    }

    @Override
    public final Object read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        KSerializer<Object> serializer = this.serializer(type, hints);
        if (serializer == null) {
            throw new HttpMessageNotReadableException("Could not find KSerializer for " + String.valueOf(type), inputMessage);
        }
        return this.readInternal(serializer, this.format, inputMessage);
    }

    protected abstract Object readInternal(KSerializer<Object> var1, T var2, HttpInputMessage var3) throws IOException, HttpMessageNotReadableException;

    @Override
    protected final void writeInternal(Object object, ResolvableType type, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        ResolvableType resolvableType = ResolvableType.NONE.equals((Object)type) ? ResolvableType.forInstance((Object)object) : type;
        KSerializer<Object> serializer = this.serializer(resolvableType, hints);
        if (serializer == null) {
            throw new HttpMessageNotWritableException("Could not find KSerializer for " + String.valueOf(resolvableType));
        }
        this.writeInternal(object, serializer, this.format, outputMessage);
    }

    protected abstract void writeInternal(Object var1, KSerializer<Object> var2, T var3, HttpOutputMessage var4) throws IOException, HttpMessageNotWritableException;

    private @Nullable KSerializer<Object> serializer(ResolvableType resolvableType, @Nullable Map<String, Object> hints) {
        if (hints != null && hints.containsKey(KType.class.getName())) {
            KType type = (KType)hints.get(KType.class.getName());
            KSerializer serializer = this.kTypeSerializerCache.get(type);
            if (serializer == null) {
                try {
                    serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (KType)type);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (serializer != null) {
                    this.kTypeSerializerCache.put(type, (KSerializer<Object>)serializer);
                }
            }
            return serializer;
        }
        Type type = resolvableType.getType();
        KSerializer serializer = this.typeSerializerCache.get(type);
        if (serializer == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                this.typeSerializerCache.put(type, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }

    @Override
    protected boolean supportsRepeatableWrites(Object object) {
        return true;
    }
}

