/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class NettyHeadersAdapter
implements MultiValueMap<String, String> {
    private final io.netty.handler.codec.http.HttpHeaders headers;

    NettyHeadersAdapter(io.netty.handler.codec.http.HttpHeaders headers) {
        this.headers = headers;
    }

    @Nullable
    public String getFirst(String key) {
        return this.headers.get(key);
    }

    public void add(String key, @Nullable String value) {
        this.headers.add(key, (Object)value);
    }

    public void addAll(String key, List<? extends String> values) {
        this.headers.add(key, values);
    }

    public void addAll(MultiValueMap<String, String> values) {
        values.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    public void set(String key, @Nullable String value) {
        this.headers.set(key, (Object)value);
    }

    public void setAll(Map<String, String> values) {
        values.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).set(arg_0, arg_1));
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap singleValueMap = CollectionUtils.newLinkedHashMap((int)this.headers.size());
        this.headers.entries().forEach(entry -> {
            if (!singleValueMap.containsKey(entry.getKey())) {
                singleValueMap.put(entry.getKey(), entry.getValue());
            }
        });
        return singleValueMap;
    }

    public int size() {
        return this.headers.names().size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return key instanceof String && this.headers.contains((String)key);
    }

    public boolean containsValue(Object value) {
        return value instanceof String && this.headers.entries().stream().anyMatch(entry -> value.equals(entry.getValue()));
    }

    @Nullable
    public List<String> get(Object key) {
        if (this.containsKey(key)) {
            return this.headers.getAll((String)key);
        }
        return null;
    }

    @Nullable
    public List<String> put(String key, @Nullable List<String> value) {
        List previousValues = this.headers.getAll(key);
        this.headers.set(key, value);
        return previousValues;
    }

    @Nullable
    public List<String> remove(Object key) {
        if (key instanceof String) {
            List previousValues = this.headers.getAll((String)key);
            this.headers.remove((String)key);
            return previousValues;
        }
        return null;
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach((arg_0, arg_1) -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).add(arg_0, arg_1));
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return this.headers.names();
    }

    public Collection<List<String>> values() {
        return this.headers.names().stream().map(arg_0 -> ((io.netty.handler.codec.http.HttpHeaders)this.headers).getAll(arg_0)).collect(Collectors.toList());
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return NettyHeadersAdapter.this.headers.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            return NettyHeadersAdapter.this.headers.getAll(this.key);
        }

        @Override
        public List<String> setValue(List<String> value) {
            List previousValues = NettyHeadersAdapter.this.headers.getAll(this.key);
            NettyHeadersAdapter.this.headers.set(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private Iterator<String> names;

        private EntryIterator() {
            this.names = NettyHeadersAdapter.this.headers.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

