/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.WithoutTransactionOperations;

public interface TransactionOperations {
    public <T> @Nullable T execute(TransactionCallback<T> var1) throws TransactionException;

    default public void executeWithoutResult(Consumer<TransactionStatus> action) throws TransactionException {
        this.execute(status -> {
            action.accept(status);
            return null;
        });
    }

    public static TransactionOperations withoutTransaction() {
        return WithoutTransactionOperations.INSTANCE;
    }
}

