/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.Conventions;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.aot.AotTestContextInitializers;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class DependencyInjectionTestExecutionListener
extends AbstractTestExecutionListener {
    public static final String REINJECT_DEPENDENCIES_ATTRIBUTE = Conventions.getQualifiedAttributeName(DependencyInjectionTestExecutionListener.class, (String)"reinjectDependencies");
    private static final Log logger = LogFactory.getLog(DependencyInjectionTestExecutionListener.class);
    private final AotTestContextInitializers aotTestContextInitializers = new AotTestContextInitializers();

    @Override
    public final int getOrder() {
        return 2000;
    }

    @Override
    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Performing dependency injection for test context " + testContext));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing dependency injection for test class " + testContext.getTestClass().getName()));
        }
        if (this.runningInAotMode(testContext.getTestClass())) {
            this.injectDependenciesInAotMode(testContext);
        } else {
            this.injectDependencies(testContext);
        }
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Reinjecting dependencies for test context " + testContext));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reinjecting dependencies for test class " + testContext.getTestClass().getName()));
            }
            if (this.runningInAotMode(testContext.getTestClass())) {
                this.injectDependenciesInAotMode(testContext);
            } else {
                this.injectDependencies(testContext);
            }
        }
    }

    protected void injectDependencies(TestContext testContext) throws Exception {
        Object bean = testContext.getTestInstance();
        Class<?> clazz = testContext.getTestClass();
        AutowireCapableBeanFactory beanFactory = testContext.getApplicationContext().getAutowireCapableBeanFactory();
        beanFactory.autowireBeanProperties(bean, 0, false);
        beanFactory.initializeBean(bean, clazz.getName() + ".ORIGINAL");
        testContext.removeAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE);
    }

    private void injectDependenciesInAotMode(TestContext testContext) throws Exception {
        ApplicationContext applicationContext = testContext.getApplicationContext();
        if (!(applicationContext instanceof GenericApplicationContext)) {
            throw new IllegalStateException("AOT ApplicationContext must be a GenericApplicationContext instead of " + applicationContext.getClass().getName());
        }
        GenericApplicationContext gac = (GenericApplicationContext)applicationContext;
        Object bean = testContext.getTestInstance();
        String beanName = testContext.getTestClass().getName() + ".ORIGINAL";
        ConfigurableListableBeanFactory beanFactory = gac.getBeanFactory();
        AutowiredAnnotationBeanPostProcessor autowiredAnnotationBpp = new AutowiredAnnotationBeanPostProcessor();
        autowiredAnnotationBpp.setBeanFactory((BeanFactory)beanFactory);
        autowiredAnnotationBpp.processInjection(bean);
        CommonAnnotationBeanPostProcessor commonAnnotationBpp = new CommonAnnotationBeanPostProcessor();
        commonAnnotationBpp.setBeanFactory((BeanFactory)beanFactory);
        commonAnnotationBpp.processInjection(bean);
        beanFactory.initializeBean(bean, beanName);
        testContext.removeAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE);
    }

    private boolean runningInAotMode(Class<?> testClass) {
        return this.aotTestContextInitializers.isSupportedTestClass(testClass);
    }
}

