/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public abstract class AbstractDirtiesContextTestExecutionListener
extends AbstractTestExecutionListener {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public abstract int getOrder();

    protected void dirtyContext(TestContext testContext, @Nullable DirtiesContext.HierarchyMode hierarchyMode) {
        testContext.markApplicationContextDirty(hierarchyMode);
        testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, Boolean.TRUE);
    }

    protected void beforeOrAfterTestMethod(TestContext testContext, DirtiesContext.MethodMode requiredMethodMode, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        Assert.notNull((Object)((Object)requiredMethodMode), (String)"requiredMethodMode must not be null");
        Assert.notNull((Object)((Object)requiredClassMode), (String)"requiredClassMode must not be null");
        Class<?> testClass = testContext.getTestClass();
        Method testMethod = testContext.getTestMethod();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        DirtiesContext methodAnn = (DirtiesContext)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)testMethod, DirtiesContext.class);
        DirtiesContext classAnn = TestContextAnnotationUtils.findMergedAnnotation(testClass, DirtiesContext.class);
        boolean methodAnnotated = methodAnn != null;
        boolean classAnnotated = classAnn != null;
        DirtiesContext.MethodMode methodMode = methodAnnotated ? methodAnn.methodMode() : null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? classAnn.classMode() : null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"%s test method: context %s, class annotated with @DirtiesContext [%s] with mode [%s], method annotated with @DirtiesContext [%s] with mode [%s]".formatted(new Object[]{AbstractDirtiesContextTestExecutionListener.getPhase(requiredMethodMode), testContext, classAnnotated, classMode, methodAnnotated, methodMode}));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"%s test method: class [%s], method [%s], class annotated with @DirtiesContext [%s] with mode [%s], method annotated with @DirtiesContext [%s] with mode [%s]".formatted(new Object[]{AbstractDirtiesContextTestExecutionListener.getPhase(requiredMethodMode), testClass.getSimpleName(), testMethod.getName(), classAnnotated, classMode, methodAnnotated, methodMode}));
        }
        if (methodMode == requiredMethodMode || classMode == requiredClassMode) {
            DirtiesContext.HierarchyMode hierarchyMode = methodAnnotated ? methodAnn.hierarchyMode() : classAnn.hierarchyMode();
            this.dirtyContext(testContext, hierarchyMode);
        }
    }

    protected void beforeOrAfterTestClass(TestContext testContext, DirtiesContext.ClassMode requiredClassMode) throws Exception {
        DirtiesContext.ClassMode classMode;
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        Assert.notNull((Object)((Object)requiredClassMode), (String)"requiredClassMode must not be null");
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull(testClass, (String)"The test class of the supplied TestContext must not be null");
        DirtiesContext dirtiesContext = TestContextAnnotationUtils.findMergedAnnotation(testClass, DirtiesContext.class);
        boolean classAnnotated = dirtiesContext != null;
        DirtiesContext.ClassMode classMode2 = classMode = classAnnotated ? dirtiesContext.classMode() : null;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"%s test class: context %s, class annotated with @DirtiesContext [%s] with mode [%s]".formatted(new Object[]{AbstractDirtiesContextTestExecutionListener.getPhase(requiredClassMode), testContext, classAnnotated, classMode}));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"%s test class: class [%s], class annotated with @DirtiesContext [%s] with mode [%s]".formatted(new Object[]{AbstractDirtiesContextTestExecutionListener.getPhase(requiredClassMode), testClass.getSimpleName(), classAnnotated, classMode}));
        }
        if (classMode == requiredClassMode) {
            this.dirtyContext(testContext, dirtiesContext.hierarchyMode());
        }
    }

    private static String getPhase(DirtiesContext.ClassMode classMode) {
        return classMode.name().startsWith("BEFORE") ? "Before" : "After";
    }

    private static String getPhase(DirtiesContext.MethodMode methodMode) {
        return methodMode.name().startsWith("BEFORE") ? "Before" : "After";
    }
}

