/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ContextLoaderUtils {
    static final String GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX = "ContextHierarchyLevel#";
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);

    ContextLoaderUtils() {
    }

    static List<List<ContextConfigurationAttributes>> resolveContextHierarchyAttributes(Class<?> testClass) {
        TestContextAnnotationUtils.UntypedAnnotationDescriptor desc;
        Assert.notNull(testClass, (String)"Class must not be null");
        Class<ContextConfiguration> contextConfigType = ContextConfiguration.class;
        Class<ContextHierarchy> contextHierarchyType = ContextHierarchy.class;
        ArrayList<List<ContextConfigurationAttributes>> hierarchyAttributes = new ArrayList<List<ContextConfigurationAttributes>>();
        Assert.notNull((Object)desc, () -> String.format("Could not find an 'annotation declaring class' for annotation type [%s] or [%s] and test class [%s]", contextConfigType.getName(), contextHierarchyType.getName(), testClass.getName()));
        for (desc = TestContextAnnotationUtils.findAnnotationDescriptorForTypes(testClass, contextConfigType, contextHierarchyType); desc != null; desc = desc.next()) {
            Class<?> rootDeclaringClass = desc.getRootDeclaringClass();
            Class<?> declaringClass = desc.getDeclaringClass();
            boolean contextConfigDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextConfigType, declaringClass);
            boolean contextHierarchyDeclaredLocally = AnnotationUtils.isAnnotationDeclaredLocally(contextHierarchyType, declaringClass);
            if (contextConfigDeclaredLocally && contextHierarchyDeclaredLocally) {
                String msg = String.format("Class [%s] has been configured with both @ContextConfiguration and @ContextHierarchy. Only one of these annotations may be declared on a test class or composed annotation.", declaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            ArrayList<ContextConfigurationAttributes> configAttributesList = new ArrayList<ContextConfigurationAttributes>();
            if (contextConfigDeclaredLocally) {
                ContextConfiguration contextConfiguration = (ContextConfiguration)desc.getAnnotation();
                ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(contextConfiguration, rootDeclaringClass, configAttributesList);
            } else if (contextHierarchyDeclaredLocally) {
                ContextHierarchy contextHierarchy = (ContextHierarchy)AnnotationUtils.getAnnotation(declaringClass, contextHierarchyType);
                if (contextHierarchy != null) {
                    for (ContextConfiguration contextConfiguration : contextHierarchy.value()) {
                        ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(contextConfiguration, rootDeclaringClass, configAttributesList);
                    }
                }
            } else {
                String msg = String.format("Test class [%s] has been configured with neither @ContextConfiguration nor @ContextHierarchy as a class-level annotation.", rootDeclaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            hierarchyAttributes.add(0, configAttributesList);
        }
        return hierarchyAttributes;
    }

    static Map<String, List<ContextConfigurationAttributes>> buildContextHierarchyMap(Class<?> testClass) {
        LinkedHashMap<String, List<ContextConfigurationAttributes>> map = new LinkedHashMap<String, List<ContextConfigurationAttributes>>();
        int hierarchyLevel = 1;
        for (List<ContextConfigurationAttributes> configAttributesList : ContextLoaderUtils.resolveContextHierarchyAttributes(testClass)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                Object name = configAttributes.getName();
                if (!StringUtils.hasText((String)name)) {
                    name = GENERATED_CONTEXT_HIERARCHY_LEVEL_PREFIX + hierarchyLevel;
                }
                if (!map.containsKey(name)) {
                    ++hierarchyLevel;
                    map.put((String)name, new ArrayList());
                }
                ((List)map.get(name)).add(configAttributes);
            }
        }
        HashSet set = new HashSet(map.values());
        if (set.size() != map.size()) {
            String msg = String.format("The @ContextConfiguration elements configured via @ContextHierarchy in test class [%s] and its superclasses must define unique contexts per hierarchy level.", testClass.getName());
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return map;
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> testClass) {
        TestContextAnnotationUtils.AnnotationDescriptor<ContextConfiguration> descriptor;
        Assert.notNull(testClass, (String)"Class must not be null");
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Assert.notNull(descriptor, () -> String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        ContextConfiguration previousAnnotation = null;
        Class<?> previousDeclaringClass = null;
        for (descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, annotationType); descriptor != null; descriptor = descriptor.next()) {
            ContextConfiguration currentAnnotation = descriptor.getAnnotation();
            if (currentAnnotation.equals(previousAnnotation) && ContextLoaderUtils.hasResources(currentAnnotation)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Ignoring duplicate %s declaration on [%s], since it is also declared on [%s].", currentAnnotation, previousDeclaringClass.getName(), descriptor.getRootDeclaringClass().getName()));
                }
            } else {
                ContextLoaderUtils.convertContextConfigToConfigAttributesAndAddToList(currentAnnotation, descriptor.getRootDeclaringClass(), attributesList);
            }
            previousAnnotation = currentAnnotation;
            previousDeclaringClass = descriptor.getRootDeclaringClass();
        }
        return attributesList;
    }

    private static boolean hasResources(ContextConfiguration contextConfiguration) {
        return contextConfiguration.locations().length > 0 || contextConfiguration.classes().length > 0;
    }

    private static void convertContextConfigToConfigAttributesAndAddToList(ContextConfiguration contextConfiguration, Class<?> declaringClass, List<ContextConfigurationAttributes> attributesList) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass.getName()));
        }
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Resolved context configuration attributes: " + String.valueOf(attributes)));
        }
        attributesList.add(attributes);
    }
}

