/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.beans.Mergeable;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockPart;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebConnection;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

final class HtmlUnitRequestBuilder
implements RequestBuilder,
Mergeable {
    private final Map<String, MockHttpSession> sessions;
    private final WebClient webClient;
    private final WebRequest webRequest;
    @Nullable
    private String contextPath;
    @Nullable
    private RequestBuilder parentBuilder;
    @Nullable
    private SmartRequestBuilder parentPostProcessor;
    @Nullable
    private RequestPostProcessor forwardPostProcessor;

    public HtmlUnitRequestBuilder(Map<String, MockHttpSession> sessions, WebClient webClient, WebRequest webRequest) {
        Assert.notNull(sessions, (String)"Sessions Map must not be null");
        Assert.notNull((Object)webClient, (String)"WebClient must not be null");
        Assert.notNull((Object)webRequest, (String)"WebRequest must not be null");
        this.sessions = sessions;
        this.webClient = webClient;
        this.webRequest = webRequest;
    }

    public void setContextPath(@Nullable String contextPath) {
        MockMvcWebConnection.validateContextPath(contextPath);
        this.contextPath = contextPath;
    }

    public void setForwardPostProcessor(RequestPostProcessor forwardPostProcessor) {
        this.forwardPostProcessor = forwardPostProcessor;
    }

    @Override
    public MockHttpServletRequest buildRequest(ServletContext servletContext) {
        String httpMethod = this.webRequest.getHttpMethod().name();
        UriComponents uri = UriComponentsBuilder.fromUriString((String)this.webRequest.getUrl().toExternalForm()).build();
        HtmlUnitMockHttpServletRequest request2 = new HtmlUnitMockHttpServletRequest(servletContext, httpMethod, uri.getPath() != null ? uri.getPath() : "");
        this.parent(request2, this.parentBuilder);
        request2.setProtocol("HTTP/1.1");
        request2.setScheme(uri.getScheme() != null ? uri.getScheme() : "");
        request2.setServerName(uri.getHost() != null ? uri.getHost() : "");
        this.ports(uri, request2);
        this.authType(request2);
        this.contextPath(request2, uri);
        this.servletPath(uri, request2);
        request2.setPathInfo(null);
        Charset charset = this.webRequest.getCharset();
        charset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        request2.setCharacterEncoding(charset.name());
        this.content(request2, charset);
        this.contentType(request2);
        this.cookies(request2);
        this.webRequest.getAdditionalHeaders().forEach(request2::addHeader);
        this.locales(request2);
        this.params(request2);
        request2.setQueryString(uri.getQuery());
        return this.postProcess(request2);
    }

    private void parent(MockHttpServletRequest request2, @Nullable RequestBuilder parent) {
        Object attrValue;
        if (parent == null) {
            return;
        }
        MockHttpServletRequest parentRequest = parent.buildRequest(request2.getServletContext());
        HttpSession parentSession = parentRequest.getSession(false);
        if (parentSession != null) {
            HttpSession localSession = request2.getSession();
            Assert.state((localSession != null ? 1 : 0) != 0, (String)"No local HttpSession");
            Enumeration attrNames = parentSession.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                attrValue = parentSession.getAttribute(attrName);
                localSession.setAttribute(attrName, attrValue);
            }
        }
        Enumeration<String> headerNames = parentRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String attrName = headerNames.nextElement();
            Enumeration<String> attrValues = parentRequest.getHeaders(attrName);
            while (attrValues.hasMoreElements()) {
                attrValue = attrValues.nextElement();
                request2.addHeader(attrName, attrValue);
            }
        }
        Map<String, String[]> parentParams = parentRequest.getParameterMap();
        parentParams.forEach(request2::addParameter);
        Object[] parentCookies = parentRequest.getCookies();
        if (!ObjectUtils.isEmpty((Object[])parentCookies)) {
            request2.setCookies((jakarta.servlet.http.Cookie[])parentCookies);
        }
        Enumeration<String> parentAttrNames = parentRequest.getAttributeNames();
        while (parentAttrNames.hasMoreElements()) {
            String parentAttrName = parentAttrNames.nextElement();
            request2.setAttribute(parentAttrName, parentRequest.getAttribute(parentAttrName));
        }
    }

    private void ports(UriComponents uriComponents, MockHttpServletRequest request2) {
        int serverPort = uriComponents.getPort();
        request2.setServerPort(serverPort);
        if (serverPort == -1) {
            int portConnection = this.webRequest.getUrl().getDefaultPort();
            request2.setLocalPort(serverPort);
            request2.setRemotePort(portConnection);
        } else {
            request2.setRemotePort(serverPort);
        }
    }

    private void authType(MockHttpServletRequest request2) {
        String authorization = this.getHeader("Authorization");
        String[] authSplit = StringUtils.split((String)authorization, (String)": ");
        if (authSplit != null) {
            request2.setAuthType(authSplit[0]);
        }
    }

    @Nullable
    private String getHeader(String headerName) {
        return (String)this.webRequest.getAdditionalHeaders().get(headerName);
    }

    private void contextPath(MockHttpServletRequest request2, UriComponents uriComponents) {
        if (this.contextPath == null) {
            List pathSegments = uriComponents.getPathSegments();
            if (pathSegments.isEmpty()) {
                request2.setContextPath("");
            } else {
                request2.setContextPath("/" + (String)pathSegments.get(0));
            }
        } else {
            String path = uriComponents.getPath();
            Assert.isTrue((path != null && path.startsWith(this.contextPath) ? 1 : 0) != 0, () -> "\"" + uriComponents.getPath() + "\" should start with context path \"" + this.contextPath + "\"");
            request2.setContextPath(this.contextPath);
        }
    }

    private void servletPath(UriComponents uriComponents, MockHttpServletRequest request2) {
        String path = uriComponents.getPath();
        String requestPath = path != null ? path : "";
        String servletPath = requestPath.substring(request2.getContextPath().length());
        servletPath = UriUtils.decode((String)servletPath, (Charset)StandardCharsets.UTF_8);
        request2.setServletPath(servletPath);
    }

    private void content(MockHttpServletRequest request2, Charset charset) {
        String requestBody = this.webRequest.getRequestBody();
        if (requestBody == null) {
            return;
        }
        request2.setContent(requestBody.getBytes(charset));
    }

    private void contentType(MockHttpServletRequest request2) {
        FormEncodingType encodingType;
        String contentType = this.getHeader("Content-Type");
        if (contentType == null && (encodingType = this.webRequest.getEncodingType()) != null) {
            contentType = encodingType.getName();
        }
        request2.setContentType(contentType != null ? contentType : "*/*");
    }

    private void cookies(MockHttpServletRequest request2) {
        ArrayList<jakarta.servlet.http.Cookie> cookies = new ArrayList<jakarta.servlet.http.Cookie>();
        String cookieHeaderValue = this.getHeader("Cookie");
        if (cookieHeaderValue != null) {
            StringTokenizer tokens = new StringTokenizer(cookieHeaderValue, "=;");
            while (tokens.hasMoreTokens()) {
                String cookieName = tokens.nextToken().trim();
                Assert.isTrue((boolean)tokens.hasMoreTokens(), () -> "Expected value for cookie name '" + cookieName + "': full cookie header was [" + cookieHeaderValue + "]");
                String cookieValue = tokens.nextToken().trim();
                this.processCookie(request2, cookies, new jakarta.servlet.http.Cookie(cookieName, cookieValue));
            }
        }
        Set managedCookies = this.webClient.getCookies(this.webRequest.getUrl());
        for (Cookie cookie : managedCookies) {
            this.processCookie(request2, cookies, new jakarta.servlet.http.Cookie(cookie.getName(), cookie.getValue()));
        }
        jakarta.servlet.http.Cookie[] parentCookies = request2.getCookies();
        if (parentCookies != null) {
            Collections.addAll(cookies, parentCookies);
        }
        if (!ObjectUtils.isEmpty(cookies)) {
            request2.setCookies(cookies.toArray(new jakarta.servlet.http.Cookie[0]));
        }
    }

    private void processCookie(MockHttpServletRequest request2, List<jakarta.servlet.http.Cookie> cookies, jakarta.servlet.http.Cookie cookie) {
        cookies.add(cookie);
        if ("JSESSIONID".equals(cookie.getName())) {
            request2.setRequestedSessionId(cookie.getValue());
            request2.setSession(this.httpSession(request2, cookie.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockHttpSession httpSession(MockHttpServletRequest request2, String sessionid) {
        MockHttpSession session;
        Map<String, MockHttpSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionid);
            if (session == null) {
                session = new HtmlUnitMockHttpSession(request2, sessionid);
                session.setNew(true);
                Map<String, MockHttpSession> map2 = this.sessions;
                synchronized (map2) {
                    this.sessions.put(sessionid, session);
                }
                this.addSessionCookie(request2, sessionid);
            } else {
                session.setNew(false);
            }
        }
        return session;
    }

    private void addSessionCookie(MockHttpServletRequest request2, String sessionid) {
        this.webClient.getCookieManager().addCookie(this.createCookie(request2, sessionid));
    }

    private void removeSessionCookie(MockHttpServletRequest request2, String sessionid) {
        this.webClient.getCookieManager().removeCookie(this.createCookie(request2, sessionid));
    }

    private Cookie createCookie(MockHttpServletRequest request2, String sessionid) {
        return new Cookie(request2.getServerName(), "JSESSIONID", sessionid, request2.getContextPath() + "/", null, request2.isSecure(), true);
    }

    private void locales(MockHttpServletRequest request2) {
        String locale = this.getHeader("Accept-Language");
        if (locale == null) {
            request2.addPreferredLocale(Locale.getDefault());
        }
    }

    private void params(MockHttpServletRequest request2) {
        for (NameValuePair param : this.webRequest.getParameters()) {
            this.addRequestParameter(request2, param);
        }
    }

    private void addRequestParameter(MockHttpServletRequest request2, NameValuePair param) {
        if (param instanceof KeyDataPair) {
            KeyDataPair pair = (KeyDataPair)param;
            File file = pair.getFile();
            MockPart part = file != null ? new MockPart(pair.getName(), file.getName(), this.readAllBytes(file)) : new MockPart(pair.getName(), pair.getValue(), pair.getData());
            MediaType mediaType = pair.getMimeType() != null ? MediaType.valueOf((String)pair.getMimeType()) : MediaType.APPLICATION_OCTET_STREAM;
            part.getHeaders().setContentType(mediaType);
            request2.addPart(part);
        } else {
            request2.addParameter(param.getName(), param.getValue());
        }
    }

    private byte[] readAllBytes(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private MockHttpServletRequest postProcess(MockHttpServletRequest request2) {
        if (this.parentPostProcessor != null) {
            request2 = this.parentPostProcessor.postProcessRequest(request2);
        }
        if (this.forwardPostProcessor != null) {
            request2 = this.forwardPostProcessor.postProcessRequest(request2);
        }
        return request2;
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(@Nullable Object parent) {
        if (parent instanceof RequestBuilder) {
            RequestBuilder requestBuilder = (RequestBuilder)parent;
            if (parent instanceof MockHttpServletRequestBuilder) {
                MockHttpServletRequestBuilder copiedParent = MockMvcRequestBuilders.get("/", new Object[0]);
                copiedParent.merge(parent);
                this.parentBuilder = copiedParent;
            } else {
                this.parentBuilder = requestBuilder;
            }
            if (parent instanceof SmartRequestBuilder) {
                SmartRequestBuilder smartRequestBuilder;
                this.parentPostProcessor = smartRequestBuilder = (SmartRequestBuilder)parent;
            }
        }
        return this;
    }

    private final class HtmlUnitMockHttpServletRequest
    extends MockHttpServletRequest {
        public HtmlUnitMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
            super(servletContext, method, requestURI);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public HttpSession getSession(boolean create) {
            HttpSession session = super.getSession(false);
            if (session == null && create) {
                HtmlUnitMockHttpSession newSession = new HtmlUnitMockHttpSession(this);
                this.setSession(newSession);
                newSession.setNew(true);
                String sessionid = newSession.getId();
                Map<String, MockHttpSession> map = HtmlUnitRequestBuilder.this.sessions;
                synchronized (map) {
                    HtmlUnitRequestBuilder.this.sessions.put(sessionid, newSession);
                }
                HtmlUnitRequestBuilder.this.addSessionCookie(this, sessionid);
                session = newSession;
            }
            return session;
        }
    }

    private final class HtmlUnitMockHttpSession
    extends MockHttpSession {
        private final MockHttpServletRequest request;

        public HtmlUnitMockHttpSession(MockHttpServletRequest request2) {
            super(request2.getServletContext());
            this.request = request2;
        }

        private HtmlUnitMockHttpSession(MockHttpServletRequest request2, String id) {
            super(request2.getServletContext(), id);
            this.request = request2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            super.invalidate();
            Map<String, MockHttpSession> map = HtmlUnitRequestBuilder.this.sessions;
            synchronized (map) {
                HtmlUnitRequestBuilder.this.sessions.remove(this.getId());
            }
            HtmlUnitRequestBuilder.this.removeSessionCookie(this.request, this.getId());
        }
    }
}

