/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;

public class StatusAssertions {
    private final ExchangeResult exchangeResult;
    private final WebTestClient.ResponseSpec responseSpec;

    StatusAssertions(ExchangeResult result, WebTestClient.ResponseSpec spec) {
        this.exchangeResult = result;
        this.responseSpec = spec;
    }

    public WebTestClient.ResponseSpec isEqualTo(HttpStatusCode status) {
        HttpStatusCode actual = this.exchangeResult.getStatus();
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", status, actual));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec isEqualTo(int status) {
        return this.isEqualTo(HttpStatusCode.valueOf((int)status));
    }

    public WebTestClient.ResponseSpec isOk() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.OK);
    }

    public WebTestClient.ResponseSpec isCreated() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.CREATED);
    }

    public WebTestClient.ResponseSpec isAccepted() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.ACCEPTED);
    }

    public WebTestClient.ResponseSpec isNoContent() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    public WebTestClient.ResponseSpec isFound() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.FOUND);
    }

    public WebTestClient.ResponseSpec isSeeOther() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.SEE_OTHER);
    }

    public WebTestClient.ResponseSpec isNotModified() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.NOT_MODIFIED);
    }

    public WebTestClient.ResponseSpec isTemporaryRedirect() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.TEMPORARY_REDIRECT);
    }

    public WebTestClient.ResponseSpec isPermanentRedirect() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.PERMANENT_REDIRECT);
    }

    public WebTestClient.ResponseSpec isBadRequest() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public WebTestClient.ResponseSpec isUnauthorized() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.UNAUTHORIZED);
    }

    public WebTestClient.ResponseSpec isForbidden() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    public WebTestClient.ResponseSpec isNotFound() {
        return this.assertStatusAndReturn((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    public WebTestClient.ResponseSpec reasonEquals(String reason) {
        String actual = StatusAssertions.getReasonPhrase(this.exchangeResult.getStatus());
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response status reason", reason, actual));
        return this.responseSpec;
    }

    private static String getReasonPhrase(HttpStatusCode statusCode) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    public WebTestClient.ResponseSpec is1xxInformational() {
        return this.assertSeriesAndReturn(HttpStatus.Series.INFORMATIONAL);
    }

    public WebTestClient.ResponseSpec is2xxSuccessful() {
        return this.assertSeriesAndReturn(HttpStatus.Series.SUCCESSFUL);
    }

    public WebTestClient.ResponseSpec is3xxRedirection() {
        return this.assertSeriesAndReturn(HttpStatus.Series.REDIRECTION);
    }

    public WebTestClient.ResponseSpec is4xxClientError() {
        return this.assertSeriesAndReturn(HttpStatus.Series.CLIENT_ERROR);
    }

    public WebTestClient.ResponseSpec is5xxServerError() {
        return this.assertSeriesAndReturn(HttpStatus.Series.SERVER_ERROR);
    }

    public WebTestClient.ResponseSpec value(Matcher<? super Integer> matcher) {
        int actual = this.exchangeResult.getStatus().value();
        this.exchangeResult.assertWithDiagnostics(() -> MatcherAssert.assertThat((String)"Response status", (Object)actual, (Matcher)matcher));
        return this.responseSpec;
    }

    public WebTestClient.ResponseSpec value(Consumer<Integer> consumer) {
        int actual = this.exchangeResult.getStatus().value();
        this.exchangeResult.assertWithDiagnostics(() -> consumer.accept(actual));
        return this.responseSpec;
    }

    private WebTestClient.ResponseSpec assertStatusAndReturn(HttpStatusCode expected) {
        HttpStatusCode actual = this.exchangeResult.getStatus();
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Status", expected, actual));
        return this.responseSpec;
    }

    private WebTestClient.ResponseSpec assertSeriesAndReturn(HttpStatus.Series expected) {
        HttpStatusCode status = this.exchangeResult.getStatus();
        HttpStatus.Series series = HttpStatus.Series.resolve((int)status.value());
        this.exchangeResult.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Range for response status value " + status, expected, series));
        return this.responseSpec;
    }
}

