/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.text.ParseException;
import org.hamcrest.Matcher;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;

public class JsonPathRequestMatchers {
    private final JsonPathExpectationsHelper jsonPathHelper;

    protected JsonPathRequestMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public <T> RequestMatcher value(final Matcher<? super T> matcher) {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request2.getBodyAsString(), matcher);
            }
        };
    }

    public <T> RequestMatcher value(final Matcher<? super T> matcher, final Class<T> targetType) {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                String body2 = request2.getBodyAsString();
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(body2, matcher, targetType);
            }
        };
    }

    public RequestMatcher value(final Object expectedValue) {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValue(request2.getBodyAsString(), expectedValue);
            }
        };
    }

    public RequestMatcher exists() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.exists(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher doesNotExist() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.doesNotExist(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher hasJsonPath() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) {
                JsonPathRequestMatchers.this.jsonPathHelper.hasJsonPath(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher doesNotHaveJsonPath() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) {
                JsonPathRequestMatchers.this.jsonPathHelper.doesNotHaveJsonPath(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isEmpty() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsEmpty(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isNotEmpty() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsNotEmpty(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isString() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsString(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isBoolean() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsBoolean(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isNumber() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsNumber(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isArray() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsArray(request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher isMap() {
        return new AbstractJsonPathRequestMatcher(){

            @Override
            public void matchInternal(MockClientHttpRequest request2) throws IOException, ParseException {
                JsonPathRequestMatchers.this.jsonPathHelper.assertValueIsMap(request2.getBodyAsString());
            }
        };
    }

    private static abstract class AbstractJsonPathRequestMatcher
    implements RequestMatcher {
        private AbstractJsonPathRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request2) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.matchInternal(mockRequest);
            }
            catch (ParseException ex) {
                throw new AssertionError("Failed to parse JSON request content", ex);
            }
        }

        abstract void matchInternal(MockClientHttpRequest var1) throws IOException, ParseException;
    }
}

