/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XpathExpectationsHelper {
    private final String expression;
    private final XPathExpression xpathExpression;
    private final boolean hasNamespaces;

    public XpathExpectationsHelper(String expression, @Nullable Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        this.expression = String.format(expression, args);
        this.xpathExpression = XpathExpectationsHelper.compileXpathExpression(this.expression, namespaces);
        this.hasNamespaces = !CollectionUtils.isEmpty(namespaces);
    }

    private static XPathExpression compileXpathExpression(String expression, @Nullable Map<String, String> namespaces) throws XPathExpressionException {
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(namespaces != null ? namespaces : Collections.emptyMap());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        return xpath.compile(expression);
    }

    protected XPathExpression getXpathExpression() {
        return this.xpathExpression;
    }

    public void assertNode(byte[] content, @Nullable String encoding, Matcher<? super Node> matcher) throws Exception {
        Node node = this.evaluateXpath(content, encoding, Node.class);
        MatcherAssert.assertThat((String)("XPath " + this.expression), (Object)node, matcher);
    }

    public void exists(byte[] content, @Nullable String encoding) throws Exception {
        Node node = this.evaluateXpath(content, encoding, Node.class);
        AssertionErrors.assertTrue("XPath " + this.expression + " does not exist", node != null);
    }

    public void doesNotExist(byte[] content, @Nullable String encoding) throws Exception {
        Node node = this.evaluateXpath(content, encoding, Node.class);
        AssertionErrors.assertTrue("XPath " + this.expression + " exists", node == null);
    }

    public void assertNodeCount(byte[] content, @Nullable String encoding, Matcher<Integer> matcher) throws Exception {
        NodeList nodeList = this.evaluateXpath(content, encoding, NodeList.class);
        String reason = "nodeCount for XPath " + this.expression;
        MatcherAssert.assertThat((String)reason, (Object)(nodeList != null ? nodeList.getLength() : 0), matcher);
    }

    public void assertNodeCount(byte[] content, @Nullable String encoding, int expectedCount) throws Exception {
        NodeList nodeList = this.evaluateXpath(content, encoding, NodeList.class);
        AssertionErrors.assertEquals("nodeCount for XPath " + this.expression, expectedCount, nodeList != null ? nodeList.getLength() : 0);
    }

    public void assertString(byte[] content, @Nullable String encoding, Matcher<? super String> matcher) throws Exception {
        String actual = this.evaluateXpath(content, encoding, String.class);
        MatcherAssert.assertThat((String)("XPath " + this.expression), (Object)actual, matcher);
    }

    public void assertString(byte[] content, @Nullable String encoding, String expectedValue) throws Exception {
        String actual = this.evaluateXpath(content, encoding, String.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, actual);
    }

    public void assertNumber(byte[] content, @Nullable String encoding, Matcher<? super Double> matcher) throws Exception {
        Double actual = this.evaluateXpath(content, encoding, Double.class);
        MatcherAssert.assertThat((String)("XPath " + this.expression), (Object)actual, matcher);
    }

    public void assertNumber(byte[] content, @Nullable String encoding, Double expectedValue) throws Exception {
        Double actual = this.evaluateXpath(content, encoding, Double.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, actual);
    }

    public void assertBoolean(byte[] content, @Nullable String encoding, boolean expectedValue) throws Exception {
        String actual = this.evaluateXpath(content, encoding, String.class);
        AssertionErrors.assertEquals("XPath " + this.expression, expectedValue, Boolean.parseBoolean(actual));
    }

    @Nullable
    public <T> T evaluateXpath(byte[] content, @Nullable String encoding, Class<T> targetClass) throws Exception {
        Document document = this.parseXmlByteArray(content, encoding);
        return this.evaluateXpath(document, this.toQName(targetClass), targetClass);
    }

    protected Document parseXmlByteArray(byte[] xml, @Nullable String encoding) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(this.hasNamespaces);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml));
        if (StringUtils.hasText((String)encoding)) {
            inputSource.setEncoding(encoding);
        }
        return documentBuilder.parse(inputSource);
    }

    @Nullable
    protected <T> T evaluateXpath(Document document, QName evaluationType, Class<T> expectedClass) throws XPathExpressionException {
        return (T)this.getXpathExpression().evaluate(document, evaluationType);
    }

    private <T> QName toQName(Class<T> expectedClass) {
        QName evaluationType;
        if (Number.class.isAssignableFrom(expectedClass)) {
            evaluationType = XPathConstants.NUMBER;
        } else if (CharSequence.class.isAssignableFrom(expectedClass)) {
            evaluationType = XPathConstants.STRING;
        } else if (Boolean.class.isAssignableFrom(expectedClass)) {
            evaluationType = XPathConstants.BOOLEAN;
        } else if (Node.class.isAssignableFrom(expectedClass)) {
            evaluationType = XPathConstants.NODE;
        } else if (NodeList.class.isAssignableFrom(expectedClass)) {
            evaluationType = XPathConstants.NODESET;
        } else {
            throw new IllegalArgumentException("Unexpected target class " + expectedClass + ". Supported: numbers, strings, boolean, and org.w3c.Node and NodeList");
        }
        return evaluationType;
    }
}

