/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockServerHttpResponse
extends AbstractServerHttpResponse {
    private Flux<DataBuffer> body = Flux.error((Throwable)new IllegalStateException("No content was written nor was setComplete() called on this response."));
    private Function<Flux<DataBuffer>, Mono<Void>> writeHandler = body -> {
        this.body = body.cache();
        return this.body.then();
    };

    public MockServerHttpResponse() {
        super((DataBufferFactory)new DefaultDataBufferFactory());
    }

    public void setWriteHandler(Function<Flux<DataBuffer>, Mono<Void>> writeHandler) {
        Assert.notNull(writeHandler, (String)"'writeHandler' is required");
        this.body = Flux.error((Throwable)new IllegalStateException("Not available with custom write handler."));
        this.writeHandler = writeHandler;
    }

    public <T> T getNativeResponse() {
        throw new IllegalStateException("This is a mock. No running server, no native response.");
    }

    protected void applyStatusCode() {
    }

    protected void applyHeaders() {
    }

    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> this.getHeaders().add("Set-Cookie", cookie.toString()));
    }

    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body));
    }

    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        return this.writeHandler.apply((Flux<DataBuffer>)Flux.from(body).concatMap(Flux::from));
    }

    public Mono<Void> setComplete() {
        return this.doCommit(() -> Mono.defer(() -> this.writeHandler.apply((Flux<DataBuffer>)Flux.empty())));
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    public Mono<String> getBodyAsString() {
        Charset charset = Optional.ofNullable(this.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
        return this.getBody().reduce((Object)this.bufferFactory().allocateBuffer(), (previous, current) -> {
            previous.write(new DataBuffer[]{current});
            DataBufferUtils.release((DataBuffer)current);
            return previous;
        }).map(buffer -> MockServerHttpResponse.bufferToString(buffer, charset));
    }

    private static String bufferToString(DataBuffer buffer, Charset charset) {
        byte[] bytes = new byte[buffer.readableByteCount()];
        buffer.read(bytes);
        return new String(bytes, charset);
    }
}

