/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.mock.web.MockAsyncContext;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.WebAsyncManager;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.ModelAndView;

final class TestDispatcherServlet
extends DispatcherServlet {
    private static final String KEY = TestDispatcherServlet.class.getName() + ".interceptor";

    public TestDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.registerAsyncResultInterceptors(request);
        super.service(request, response);
        this.initAsyncDispatchLatch(request);
    }

    private void registerAsyncResultInterceptors(final HttpServletRequest request) {
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        asyncManager.registerCallableInterceptor((Object)KEY, (CallableProcessingInterceptor)new CallableProcessingInterceptorAdapter(){

            public <T> void postProcess(NativeWebRequest r, Callable<T> task, Object value) throws Exception {
                TestDispatcherServlet.this.getMvcResult((ServletRequest)request).setAsyncResult(value);
            }
        });
        asyncManager.registerDeferredResultInterceptor((Object)KEY, (DeferredResultProcessingInterceptor)new DeferredResultProcessingInterceptorAdapter(){

            public <T> void postProcess(NativeWebRequest r, DeferredResult<T> result, Object value) throws Exception {
                TestDispatcherServlet.this.getMvcResult((ServletRequest)request).setAsyncResult(value);
            }
        });
    }

    private void initAsyncDispatchLatch(HttpServletRequest request) {
        if (request.getAsyncContext() != null) {
            final CountDownLatch dispatchLatch = new CountDownLatch(1);
            ((MockAsyncContext)request.getAsyncContext()).addDispatchHandler(new Runnable(){

                @Override
                public void run() {
                    dispatchLatch.countDown();
                }
            });
            this.getMvcResult((ServletRequest)request).setAsyncDispatchLatch(dispatchLatch);
        }
    }

    protected DefaultMvcResult getMvcResult(ServletRequest request) {
        return (DefaultMvcResult)request.getAttribute(MockMvc.MVC_RESULT_ATTRIBUTE);
    }

    protected HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        HandlerExecutionChain chain = super.getHandler(request);
        if (chain != null) {
            DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
            mvcResult.setHandler(chain.getHandler());
            mvcResult.setInterceptors(chain.getInterceptors());
        }
        return chain;
    }

    protected void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
        mvcResult.setModelAndView(mv);
        super.render(mv, request, response);
    }

    protected ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView mav = super.processHandlerException(request, response, handler, ex);
        DefaultMvcResult mvcResult = this.getMvcResult((ServletRequest)request);
        mvcResult.setResolvedException(ex);
        mvcResult.setModelAndView(mav);
        return mav;
    }
}

