/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.spi.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.util.Assert;

class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private @Nullable LoadTimeWeaver loadTimeWeaver;
    private @Nullable ClassLoader classLoader;

    SpringPersistenceUnitInfo() {
    }

    public void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull((Object)loadTimeWeaver, (String)"LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    public void init(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver != null) {
            this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No LoadTimeWeaver setup: ignoring JPA class transformer");
        }
    }

    @Override
    public ClassLoader getNewTempClassLoader() {
        Object tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            DecoratingClassLoader dcl = (DecoratingClassLoader)tcl;
            dcl.excludePackage(packageToExclude);
        }
        return tcl;
    }
}

