/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.jndi.SimpleNamingContext;

public class SimpleNamingContextBuilder
implements InitialContextFactoryBuilder {
    private static SimpleNamingContextBuilder activated;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Hashtable boundObjects = new Hashtable();

    public static SimpleNamingContextBuilder getCurrentContextBuilder() {
        return activated;
    }

    public static SimpleNamingContextBuilder emptyActivatedContextBuilder() throws NamingException {
        if (activated != null) {
            activated.clear();
        } else {
            SimpleNamingContextBuilder builder = new SimpleNamingContextBuilder();
            builder.activate();
        }
        return activated;
    }

    public void activate() throws IllegalStateException, NamingException {
        this.logger.info((Object)"Activating simple JNDI environment");
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            throw new IllegalStateException("Cannot activate SimpleNamingContextBuilder: there is already a JNDI provider registered. Note that JNDI is a JVM-wide service, shared at the JVM system class loader level, with no reset option. As a consequence, a JNDI provider must only be registered once per JVM.");
        }
        NamingManager.setInitialContextFactoryBuilder(this);
        activated = this;
    }

    public void clear() {
        this.boundObjects.clear();
    }

    public void bind(String name, Object obj) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Static JNDI binding: [" + name + "] = [" + obj + "]"));
        }
        this.boundObjects.put(name, obj);
    }

    public InitialContextFactory createInitialContextFactory(Hashtable environment) {
        return new InitialContextFactory(){

            public Context getInitialContext(Hashtable environment) {
                return new SimpleNamingContext("", SimpleNamingContextBuilder.this.boundObjects, environment);
            }
        };
    }
}

