/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.messaging.simp.SimpAttributes;
import org.springframework.messaging.simp.SimpAttributesContextHolder;

public class SimpSessionScope
implements Scope {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory<?> objectFactory) {
        SimpAttributes simpAttributes = SimpAttributesContextHolder.currentAttributes();
        Object scopedObject = simpAttributes.getAttribute(name);
        if (scopedObject != null) {
            return scopedObject;
        }
        Object object = simpAttributes.getSessionMutex();
        synchronized (object) {
            scopedObject = simpAttributes.getAttribute(name);
            if (scopedObject == null) {
                scopedObject = objectFactory.getObject();
                simpAttributes.setAttribute(name, scopedObject);
            }
            return scopedObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object remove(String name) {
        SimpAttributes simpAttributes = SimpAttributesContextHolder.currentAttributes();
        Object object = simpAttributes.getSessionMutex();
        synchronized (object) {
            Object value = simpAttributes.getAttribute(name);
            if (value != null) {
                simpAttributes.removeAttribute(name);
                return value;
            }
            return null;
        }
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        SimpAttributesContextHolder.currentAttributes().registerDestructionCallback(name, callback);
    }

    public String getConversationId() {
        return SimpAttributesContextHolder.currentAttributes().getSessionId();
    }
}

