/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.ReconnectStrategy;
import org.springframework.messaging.tcp.TcpConnectionHandler;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.MonoToListenableFutureAdapter;
import org.springframework.messaging.tcp.reactor.ReactorNettyCodec;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpConnection;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;
import reactor.ipc.netty.tcp.TcpClient;

public class ReactorNettyTcpClient<P>
implements TcpOperations<P> {
    private static Log logger = LogFactory.getLog(ReactorNettyTcpClient.class);
    private static final int PUBLISH_ON_BUFFER_SIZE = 16;
    private final TcpClient tcpClient;
    private final ReactorNettyCodec<P> codec;
    @Nullable
    private final ChannelGroup channelGroup;
    @Nullable
    private LoopResources loopResources;
    @Nullable
    private PoolResources poolResources;
    private final Scheduler scheduler = Schedulers.newParallel((String)"tcp-client-scheduler");
    private volatile boolean stopping = false;

    public ReactorNettyTcpClient(String host, int port, ReactorNettyCodec<P> codec) {
        this((ClientOptions.Builder<?> builder) -> builder.host(host).port(port), codec);
    }

    public ReactorNettyTcpClient(Consumer<ClientOptions.Builder<?>> optionsConsumer, ReactorNettyCodec<P> codec) {
        Assert.notNull(optionsConsumer, (String)"Consumer<ClientOptions.Builder<?> is required");
        Assert.notNull(codec, (String)"ReactorNettyCodec is required");
        this.channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
        Consumer<ClientOptions.Builder> builtInConsumer = builder -> {
            Assert.isTrue((!builder.isLoopAvailable() && !builder.isPoolAvailable() ? 1 : 0) != 0, (String)"The provided ClientOptions.Builder contains LoopResources and/or PoolResources. Please, use the constructor that accepts a TcpClient instance for full control over initialization and lifecycle.");
            builder.channelGroup(this.channelGroup);
            builder.preferNative(false);
            this.loopResources = LoopResources.create((String)"tcp-client-loop");
            builder.loopResources(this.loopResources);
            if (!builder.isPoolDisabled()) {
                this.poolResources = PoolResources.elastic((String)"tcp-client-pool");
                builder.poolResources(this.poolResources);
            }
        };
        this.tcpClient = TcpClient.create(optionsConsumer.andThen(builtInConsumer));
        this.codec = codec;
    }

    public ReactorNettyTcpClient(TcpClient tcpClient, ReactorNettyCodec<P> codec) {
        Assert.notNull((Object)tcpClient, (String)"TcpClient is required");
        Assert.notNull(codec, (String)"ReactorNettyCodec is required");
        this.tcpClient = tcpClient;
        this.codec = codec;
        this.channelGroup = null;
        this.loopResources = null;
        this.poolResources = null;
    }

    @Override
    public ListenableFuture<Void> connect(TcpConnectionHandler<P> handler) {
        Assert.notNull(handler, (String)"TcpConnectionHandler is required");
        if (this.stopping) {
            return this.handleShuttingDownConnectFailure(handler);
        }
        Mono connectMono = this.tcpClient.newHandler((BiFunction)new ReactorNettyHandler(handler)).doOnError(handler::afterConnectFailure).then();
        return new MonoToListenableFutureAdapter<Void>((Mono<Void>)connectMono);
    }

    @Override
    public ListenableFuture<Void> connect(TcpConnectionHandler<P> handler, ReconnectStrategy strategy) {
        Assert.notNull(handler, (String)"TcpConnectionHandler is required");
        Assert.notNull((Object)strategy, (String)"ReconnectStrategy is required");
        if (this.stopping) {
            return this.handleShuttingDownConnectFailure(handler);
        }
        MonoProcessor connectMono = MonoProcessor.create();
        this.tcpClient.newHandler((BiFunction)new ReactorNettyHandler(handler)).doOnNext(this.updateConnectMono((MonoProcessor<Void>)connectMono)).doOnError(this.updateConnectMono((MonoProcessor<Void>)connectMono)).doOnError(handler::afterConnectFailure).flatMap(NettyContext::onClose).retryWhen(this.reconnectFunction(strategy)).repeatWhen(this.reconnectFunction(strategy)).subscribe();
        return new MonoToListenableFutureAdapter<Void>((Mono<Void>)connectMono);
    }

    private ListenableFuture<Void> handleShuttingDownConnectFailure(TcpConnectionHandler<P> handler) {
        IllegalStateException ex = new IllegalStateException("Shutting down.");
        handler.afterConnectFailure(ex);
        return new MonoToListenableFutureAdapter<Void>((Mono<Void>)Mono.error((Throwable)ex));
    }

    private <T> Consumer<T> updateConnectMono(MonoProcessor<Void> connectMono) {
        return o -> {
            if (!connectMono.isTerminated()) {
                if (o instanceof Throwable) {
                    connectMono.onError((Throwable)o);
                } else {
                    connectMono.onComplete();
                }
            }
        };
    }

    private <T> Function<Flux<T>, Publisher<?>> reconnectFunction(ReconnectStrategy reconnectStrategy) {
        return flux -> flux.scan((Object)1, (count, element) -> {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            return n;
        }).flatMap(attempt -> Optional.ofNullable(reconnectStrategy.getTimeToNextAttempt((int)attempt)).map(time -> Mono.delay((Duration)Duration.ofMillis(time), (Scheduler)this.scheduler)).orElse(Mono.empty()));
    }

    @Override
    public ListenableFuture<Void> shutdown() {
        Mono result;
        if (this.stopping) {
            SettableListenableFuture future = new SettableListenableFuture();
            future.set(null);
            return future;
        }
        this.stopping = true;
        if (this.channelGroup != null) {
            result = FutureMono.from((Future)this.channelGroup.close());
            if (this.loopResources != null) {
                result = result.onErrorResume(ex -> Mono.empty()).then(this.loopResources.disposeLater());
            }
            if (this.poolResources != null) {
                result = result.onErrorResume(ex -> Mono.empty()).then(this.poolResources.disposeLater());
            }
            result = result.onErrorResume(ex -> Mono.empty()).then(this.stopScheduler());
        } else {
            result = this.stopScheduler();
        }
        return new MonoToListenableFutureAdapter<Void>((Mono<Void>)result);
    }

    private Mono<Void> stopScheduler() {
        return Mono.fromRunnable(() -> {
            this.scheduler.dispose();
            for (int i = 0; i < 20 && !this.scheduler.isDisposed(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Throwable ex) {
                    break;
                }
            }
        });
    }

    public String toString() {
        return "ReactorNettyTcpClient[" + this.tcpClient + "]";
    }

    private static class StompMessageDecoder<P>
    extends ByteToMessageDecoder {
        private final ReactorNettyCodec<P> codec;

        public StompMessageDecoder(ReactorNettyCodec<P> codec) {
            this.codec = codec;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            Collection<Message<P>> messages = this.codec.decode(in);
            out.addAll(messages);
        }
    }

    private class ReactorNettyHandler
    implements BiFunction<NettyInbound, NettyOutbound, Publisher<Void>> {
        private final TcpConnectionHandler<P> connectionHandler;

        ReactorNettyHandler(TcpConnectionHandler<P> handler) {
            this.connectionHandler = handler;
        }

        @Override
        public Publisher<Void> apply(NettyInbound inbound, NettyOutbound outbound) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connected to " + inbound.remoteAddress()));
            }
            DirectProcessor completion = DirectProcessor.create();
            ReactorNettyTcpConnection connection = new ReactorNettyTcpConnection(inbound, outbound, ReactorNettyTcpClient.this.codec, (DirectProcessor<Void>)completion);
            ReactorNettyTcpClient.this.scheduler.schedule(() -> this.connectionHandler.afterConnected(connection));
            inbound.context().addHandler(new StompMessageDecoder(ReactorNettyTcpClient.this.codec));
            inbound.receiveObject().cast(Message.class).publishOn(ReactorNettyTcpClient.this.scheduler, 16).subscribe(this.connectionHandler::handleMessage, this.connectionHandler::handleFailure, this.connectionHandler::afterConnectionClosed);
            return completion;
        }
    }
}

