/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.AbstractMessageCondition;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.util.Assert;

public class SimpMessageTypeMessageCondition
extends AbstractMessageCondition<SimpMessageTypeMessageCondition> {
    public static final SimpMessageTypeMessageCondition MESSAGE = new SimpMessageTypeMessageCondition(SimpMessageType.MESSAGE);
    public static final SimpMessageTypeMessageCondition SUBSCRIBE = new SimpMessageTypeMessageCondition(SimpMessageType.SUBSCRIBE);
    private final SimpMessageType messageType;

    public SimpMessageTypeMessageCondition(SimpMessageType messageType) {
        Assert.notNull((Object)((Object)messageType), (String)"MessageType must not be null");
        this.messageType = messageType;
    }

    public SimpMessageType getMessageType() {
        return this.messageType;
    }

    @Override
    protected Collection<?> getContent() {
        return Arrays.asList(this.messageType);
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public SimpMessageTypeMessageCondition combine(SimpMessageTypeMessageCondition other) {
        return other;
    }

    @Override
    public SimpMessageTypeMessageCondition getMatchingCondition(Message<?> message) {
        Object actualMessageType = message.getHeaders().get("simpMessageType");
        if (actualMessageType == null) {
            return null;
        }
        return this;
    }

    @Override
    public int compareTo(SimpMessageTypeMessageCondition other, Message<?> message) {
        Object actualMessageType = message.getHeaders().get("simpMessageType");
        if (actualMessageType != null) {
            if (actualMessageType.equals((Object)this.getMessageType()) && actualMessageType.equals((Object)other.getMessageType())) {
                return 0;
            }
            if (actualMessageType.equals((Object)this.getMessageType())) {
                return -1;
            }
            if (actualMessageType.equals((Object)other.getMessageType())) {
                return 1;
            }
        }
        return 0;
    }
}

