/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.MimeType;

public class MappingJackson2MessageConverter
extends AbstractMessageConverter {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Boolean prettyPrint;

    public MappingJackson2MessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    @Override
    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        JavaType type = this.objectMapper.constructType(targetClass);
        return this.objectMapper.canDeserialize(type) && this.supportsMimeType(message.getHeaders());
    }

    @Override
    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        return this.objectMapper.canSerialize(payload.getClass()) && this.supportsMimeType(headers);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object convertFromInternal(Message<?> message, Class<?> targetClass) {
        JavaType javaType = this.objectMapper.constructType(targetClass);
        Object payload = message.getPayload();
        try {
            if (payload instanceof byte[]) {
                return this.objectMapper.readValue((byte[])payload, javaType);
            }
            return this.objectMapper.readValue((String)payload, javaType);
        }
        catch (IOException ex) {
            throw new MessageConversionException(message, "Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public Object convertToInternal(Object payload, MessageHeaders headers) {
        try {
            if (byte[].class.equals(this.getSerializedPayloadClass())) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                JsonEncoding encoding = this.getJsonEncoding(this.getMimeType(headers));
                JsonGenerator generator = this.objectMapper.getJsonFactory().createJsonGenerator((OutputStream)out, encoding);
                if (this.objectMapper.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                    generator.useDefaultPrettyPrinter();
                }
                this.objectMapper.writeValue(generator, payload);
                payload = out.toByteArray();
            } else {
                StringWriter writer = new StringWriter();
                this.objectMapper.writeValue((Writer)writer, payload);
                payload = ((Object)writer).toString();
            }
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
        return payload;
    }

    protected JsonEncoding getJsonEncoding(MimeType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

