/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.jms.listener.SubscriptionNameProvider;
import org.springframework.jms.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingMessageListenerAdapter
extends AbstractAdaptableMessageListener
implements SubscriptionNameProvider {
    private @Nullable InvocableHandlerMethod handlerMethod;

    public void setHandlerMethod(InvocableHandlerMethod handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    private InvocableHandlerMethod getHandlerMethod() {
        Assert.state((this.handlerMethod != null ? 1 : 0) != 0, (String)"No HandlerMethod set");
        return this.handlerMethod;
    }

    @Override
    public void onMessage(Message jmsMessage, @Nullable Session session) throws JMSException {
        Object result;
        org.springframework.messaging.Message<?> message = this.toMessagingMessage(jmsMessage);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing [" + String.valueOf(message) + "]"));
        }
        if ((result = this.invokeHandler(jmsMessage, session, message)) != null) {
            this.handleResult(result, jmsMessage, session);
        } else {
            this.logger.trace((Object)"No result object given - no result to handle");
        }
    }

    protected org.springframework.messaging.Message<?> toMessagingMessage(Message jmsMessage) {
        try {
            return (org.springframework.messaging.Message)this.getMessagingMessageConverter().fromMessage(jmsMessage);
        }
        catch (JMSException ex) {
            throw new MessageConversionException("Could not convert JMS message", ex);
        }
    }

    private @Nullable Object invokeHandler(Message jmsMessage, @Nullable Session session, org.springframework.messaging.Message<?> message) {
        InvocableHandlerMethod handlerMethod = this.getHandlerMethod();
        try {
            return handlerMethod.invoke(message, new Object[]{jmsMessage, session});
        }
        catch (MessagingException ex) {
            throw new ListenerExecutionFailedException(this.createMessagingErrorMessage("Listener method could not be invoked with incoming message"), ex);
        }
        catch (Exception ex) {
            throw new ListenerExecutionFailedException("Listener method '" + handlerMethod.getMethod().toGenericString() + "' threw exception", ex);
        }
    }

    private String createMessagingErrorMessage(String description) {
        InvocableHandlerMethod handlerMethod = this.getHandlerMethod();
        StringBuilder sb = new StringBuilder(description).append('\n').append("Endpoint handler details:\n").append("Method [").append(handlerMethod.getMethod()).append("]\n").append("Bean [").append(handlerMethod.getBean()).append("]\n");
        return sb.toString();
    }

    @Override
    protected Object preProcessResponse(Object result) {
        MessageBuilder messageBuilder;
        MethodParameter returnType = this.getHandlerMethod().getReturnType();
        if (result instanceof org.springframework.messaging.Message) {
            org.springframework.messaging.Message message = (org.springframework.messaging.Message)result;
            messageBuilder = MessageBuilder.fromMessage((org.springframework.messaging.Message)message);
        } else {
            messageBuilder = MessageBuilder.withPayload((Object)result);
        }
        MessageBuilder messageBuilder2 = messageBuilder;
        return messageBuilder2.setHeader("conversionHint", (Object)returnType).build();
    }

    @Override
    public String getSubscriptionName() {
        if (this.handlerMethod != null) {
            return this.handlerMethod.getBeanType().getName() + "." + this.handlerMethod.getMethod().getName();
        }
        return this.getClass().getName();
    }
}

