/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.AbstractPollingMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.BackOffExecution;
import org.springframework.util.backoff.FixedBackOff;

public class DefaultMessageListenerContainer
extends AbstractPollingMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(DefaultMessageListenerContainer.class) + "-";
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_CONNECTION = 1;
    public static final int CACHE_SESSION = 2;
    public static final int CACHE_CONSUMER = 3;
    public static final int CACHE_AUTO = 4;
    private static final Map<String, Integer> constants = Map.of("CACHE_NONE", 0, "CACHE_CONNECTION", 1, "CACHE_SESSION", 2, "CACHE_CONSUMER", 3, "CACHE_AUTO", 4);
    private @Nullable Executor taskExecutor;
    private boolean virtualThreads = false;
    private BackOff backOff = new FixedBackOff(5000L);
    private int cacheLevel = 4;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private int idleConsumerLimit = 1;
    private int idleTaskExecutionLimit = 1;
    private int idleReceivesPerTaskLimit = Integer.MIN_VALUE;
    private final Set<AsyncMessageListenerInvoker> scheduledInvokers = new HashSet<AsyncMessageListenerInvoker>();
    private int activeInvokerCount = 0;
    private int registeredWithDestination = 0;
    private volatile boolean recovering;
    private volatile boolean interrupted;
    private @Nullable Runnable stopCallback;
    private Object currentRecoveryMarker = new Object();
    private final Lock recoveryLock = new ReentrantLock();

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setVirtualThreads(boolean virtualThreads) {
        this.virtualThreads = virtualThreads;
    }

    public void setBackOff(BackOff backOff) {
        this.backOff = backOff;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.backOff = new FixedBackOff(recoveryInterval);
    }

    public void setCacheLevelName(String constantName) throws IllegalArgumentException {
        Assert.hasText((String)constantName, (String)"'constantName' must not be null or blank");
        Integer cacheLevel = constants.get(constantName);
        Assert.notNull((Object)cacheLevel, (String)"Only cache constants allowed");
        this.cacheLevel = cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        Assert.isTrue((boolean)constants.containsValue(cacheLevel), (String)"Only values of cache constants allowed");
        this.cacheLevel = cacheLevel;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    @Override
    public void setConcurrency(String concurrency) {
        try {
            int separatorIndex = concurrency.indexOf(45);
            if (separatorIndex != -1) {
                this.setConcurrentConsumers(Integer.parseInt(concurrency, 0, separatorIndex, 10));
                this.setMaxConcurrentConsumers(Integer.parseInt(concurrency, separatorIndex + 1, concurrency.length(), 10));
            } else {
                this.setConcurrentConsumers(1);
                this.setMaxConcurrentConsumers(Integer.parseInt(concurrency));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid concurrency value [" + concurrency + "]: only single maximum integer (for example, \"5\") and minimum-maximum combo (for example, \"3-5\") supported.");
        }
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"'concurrentConsumers' value must be at least 1 (one)");
        this.lifecycleLock.lock();
        try {
            this.concurrentConsumers = concurrentConsumers;
            if (this.maxConcurrentConsumers < concurrentConsumers) {
                this.maxConcurrentConsumers = concurrentConsumers;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getConcurrentConsumers() {
        this.lifecycleLock.lock();
        try {
            int n = this.concurrentConsumers;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue((maxConcurrentConsumers > 0 ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 1 (one)");
        this.lifecycleLock.lock();
        try {
            this.maxConcurrentConsumers = Math.max(maxConcurrentConsumers, this.concurrentConsumers);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getMaxConcurrentConsumers() {
        this.lifecycleLock.lock();
        try {
            int n = this.maxConcurrentConsumers;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue((maxMessagesPerTask != 0 ? 1 : 0) != 0, (String)"'maxMessagesPerTask' must not be 0");
        this.lifecycleLock.lock();
        try {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getMaxMessagesPerTask() {
        this.lifecycleLock.lock();
        try {
            int n = this.maxMessagesPerTask;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setIdleConsumerLimit(int idleConsumerLimit) {
        Assert.isTrue((idleConsumerLimit > 0 ? 1 : 0) != 0, (String)"'idleConsumerLimit' must be 1 or higher");
        this.lifecycleLock.lock();
        try {
            this.idleConsumerLimit = idleConsumerLimit;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getIdleConsumerLimit() {
        this.lifecycleLock.lock();
        try {
            int n = this.idleConsumerLimit;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        Assert.isTrue((idleTaskExecutionLimit > 0 ? 1 : 0) != 0, (String)"'idleTaskExecutionLimit' must be 1 or higher");
        this.lifecycleLock.lock();
        try {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getIdleTaskExecutionLimit() {
        this.lifecycleLock.lock();
        try {
            int n = this.idleTaskExecutionLimit;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void setIdleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
        Assert.isTrue((idleReceivesPerTaskLimit != 0 ? 1 : 0) != 0, (String)"'idleReceivesPerTaskLimit' must not be 0)");
        this.lifecycleLock.lock();
        try {
            this.idleReceivesPerTaskLimit = idleReceivesPerTaskLimit;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public int getIdleReceivesPerTaskLimit() {
        this.lifecycleLock.lock();
        try {
            int n = this.idleReceivesPerTaskLimit;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void initialize() {
        if (this.cacheLevel == 4) {
            this.cacheLevel = this.getTransactionManager() != null ? 0 : 3;
        }
        this.lifecycleLock.lock();
        try {
            SchedulingTaskExecutor ste;
            Executor executor;
            if (this.taskExecutor == null) {
                this.taskExecutor = this.createDefaultTaskExecutor();
            }
            if ((executor = this.taskExecutor) instanceof SchedulingTaskExecutor && (ste = (SchedulingTaskExecutor)executor).prefersShortLivedTasks()) {
                if (this.maxMessagesPerTask == Integer.MIN_VALUE) {
                    this.maxMessagesPerTask = 10;
                }
            } else if (this.idleReceivesPerTaskLimit == Integer.MIN_VALUE) {
                this.idleReceivesPerTaskLimit = 10;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        super.initialize();
    }

    @Override
    protected void doInitialize() throws JMSException {
        this.lifecycleLock.lock();
        try {
            for (int i = 0; i < this.concurrentConsumers; ++i) {
                this.scheduleNewInvoker();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doShutdown() throws JMSException {
        this.logger.debug((Object)"Waiting for shutdown of message listener invokers");
        this.lifecycleLock.lock();
        try {
            long receiveTimeout = this.getReceiveTimeout();
            long waitStartTime = System.currentTimeMillis();
            int waitCount = 0;
            while (this.activeInvokerCount > 0) {
                if (waitCount > 0 && !this.isAcceptMessagesWhileStopping() && System.currentTimeMillis() - waitStartTime >= receiveTimeout) {
                    for (AsyncMessageListenerInvoker scheduledInvoker : this.scheduledInvokers) {
                        scheduledInvoker.interruptIfNecessary();
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Still waiting for shutdown of " + this.activeInvokerCount + " message listener invokers (iteration " + waitCount + ")"));
                }
                if (receiveTimeout > 0L) {
                    this.lifecycleCondition.await(receiveTimeout, TimeUnit.MILLISECONDS);
                } else {
                    this.lifecycleCondition.await();
                }
                ++waitCount;
            }
            for (AsyncMessageListenerInvoker scheduledInvoker : this.scheduledInvokers) {
                scheduledInvoker.clearResources();
            }
            this.scheduledInvokers.clear();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void start() throws JmsException {
        this.lifecycleLock.lock();
        try {
            this.stopCallback = null;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        super.start();
    }

    public void stop(Runnable callback) throws JmsException {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning() || this.stopCallback != null) {
                callback.run();
                return;
            }
            this.stopCallback = callback;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        this.stop();
    }

    public final int getScheduledConsumerCount() {
        this.lifecycleLock.lock();
        try {
            int n = this.scheduledInvokers.size();
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final int getActiveConsumerCount() {
        this.lifecycleLock.lock();
        try {
            int n = this.activeInvokerCount;
            return n;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public boolean isRegisteredWithDestination() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.registeredWithDestination > 0;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName = this.getBeanName();
        Object threadNamePrefix = beanName != null ? beanName + "-" : DEFAULT_THREAD_NAME_PREFIX;
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor((String)threadNamePrefix);
        executor.setVirtualThreads(this.virtualThreads);
        return executor;
    }

    private void scheduleNewInvoker() {
        AsyncMessageListenerInvoker invoker = new AsyncMessageListenerInvoker();
        if (this.rescheduleTaskIfNecessary(invoker)) {
            this.scheduledInvokers.add(invoker);
        }
    }

    @Override
    protected final boolean sharedConnectionEnabled() {
        return this.getCacheLevel() >= 1;
    }

    @Override
    protected void doRescheduleTask(Object task) {
        Assert.state((this.taskExecutor != null ? 1 : 0) != 0, (String)"No TaskExecutor available");
        this.taskExecutor.execute((Runnable)task);
    }

    @Override
    protected void messageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(false);
        this.scheduleNewInvokerIfAppropriate();
    }

    @Override
    protected void noMessageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(true);
    }

    protected void scheduleNewInvokerIfAppropriate() {
        if (this.isRunning()) {
            this.resumePausedTasks();
            this.lifecycleLock.lock();
            try {
                if (this.scheduledInvokers.size() < this.maxConcurrentConsumers && this.getIdleInvokerCount() < this.idleConsumerLimit) {
                    this.scheduleNewInvoker();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Raised scheduled invoker count: " + this.scheduledInvokers.size()));
                    }
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }

    private boolean shouldRescheduleInvoker(int idleTaskExecutionCount) {
        boolean superfluous = idleTaskExecutionCount >= this.idleTaskExecutionLimit && this.getIdleInvokerCount() > 1;
        return this.scheduledInvokers.size() <= (superfluous ? this.concurrentConsumers : this.maxConcurrentConsumers);
    }

    private int getIdleInvokerCount() {
        int count = 0;
        for (AsyncMessageListenerInvoker invoker : this.scheduledInvokers) {
            if (!invoker.isIdle()) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected void establishSharedConnection() {
        try {
            super.establishSharedConnection();
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                JMSException jmsException = (JMSException)((Object)ex);
                this.invokeExceptionListener(jmsException);
            }
            this.logger.debug((Object)"Could not establish shared JMS Connection - leaving it up to asynchronous invokers to establish a Connection as soon as possible", (Throwable)ex);
        }
    }

    @Override
    protected void startSharedConnection() {
        try {
            super.startSharedConnection();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Connection start failed - relying on listeners to perform recovery", (Throwable)ex);
        }
    }

    @Override
    protected void stopSharedConnection() {
        try {
            super.stopSharedConnection();
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Connection stop failed - relying on listeners to perform recovery after restart", (Throwable)ex);
        }
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        if (ex instanceof JMSException) {
            JMSException jmsException = (JMSException)ex;
            this.invokeExceptionListener(jmsException);
        }
        if (ex instanceof AbstractJmsListeningContainer.SharedConnectionNotInitializedException) {
            if (!alreadyRecovered) {
                this.logger.debug((Object)"JMS message listener invoker needs to establish shared Connection");
            }
        } else if (alreadyRecovered) {
            this.logger.debug((Object)"Setup of JMS message listener invoker failed - already recovered by other invoker", ex);
        } else {
            String string;
            StringBuilder msg = new StringBuilder();
            msg.append("Setup of JMS message listener invoker failed for destination '");
            msg.append(this.getDestinationDescription()).append("' - trying to recover. Cause: ");
            if (ex instanceof JMSException) {
                JMSException jmsException = (JMSException)ex;
                string = JmsUtils.buildExceptionMessage(jmsException);
            } else {
                string = ex.getMessage();
            }
            msg.append(string);
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, ex);
            } else {
                this.logger.warn((Object)msg);
            }
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        this.recovering = true;
        try {
            this.refreshConnectionUntilSuccessful();
            this.refreshDestination();
        }
        finally {
            this.recovering = false;
            this.interrupted = false;
        }
    }

    protected void refreshConnectionUntilSuccessful() {
        BackOffExecution execution = this.backOff.start();
        while (this.isRunning()) {
            try {
                if (this.sharedConnectionEnabled()) {
                    this.refreshSharedConnection();
                } else {
                    Connection con = this.createConnection();
                    JmsUtils.closeConnection(con);
                }
                this.logger.debug((Object)"Successfully refreshed JMS Connection");
                break;
            }
            catch (Exception ex) {
                String string;
                if (ex instanceof JMSException) {
                    JMSException jmsException = (JMSException)((Object)ex);
                    this.invokeExceptionListener(jmsException);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Could not refresh JMS Connection for destination '");
                msg.append(this.getDestinationDescription()).append("' - retrying using ");
                msg.append(execution).append(". Cause: ");
                if (ex instanceof JMSException) {
                    JMSException jmsException = (JMSException)((Object)ex);
                    string = JmsUtils.buildExceptionMessage(jmsException);
                } else {
                    string = ex.getMessage();
                }
                msg.append(string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)msg, (Throwable)ex);
                } else {
                    this.logger.error((Object)msg);
                }
                if (this.applyBackOffTime(execution)) continue;
                this.logger.error((Object)("Stopping container for destination '" + this.getDestinationDescription() + "': back-off policy does not allow for further attempts."));
                this.stop();
            }
        }
    }

    protected void refreshDestination() {
        DestinationResolver destResolver;
        String destName = this.getDestinationName();
        if (destName != null && (destResolver = this.getDestinationResolver()) instanceof CachingDestinationResolver) {
            CachingDestinationResolver cachingResolver = (CachingDestinationResolver)destResolver;
            cachingResolver.removeFromCache(destName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyBackOffTime(BackOffExecution execution) {
        if (this.recovering && this.interrupted) {
            return false;
        }
        long interval = execution.nextBackOff();
        if (interval == -1L) {
            return false;
        }
        this.lifecycleLock.lock();
        try {
            this.lifecycleCondition.await(interval, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interEx) {
            Thread.currentThread().interrupt();
            if (this.recovering) {
                this.interrupted = true;
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return true;
    }

    public final boolean isRecovering() {
        return this.recovering;
    }

    private class AsyncMessageListenerInvoker
    implements SchedulingAwareRunnable {
        private @Nullable Session session;
        private @Nullable MessageConsumer consumer;
        private @Nullable Object lastRecoveryMarker;
        private boolean lastMessageSucceeded;
        private int idleTaskExecutionCount = 0;
        private volatile boolean idle = true;
        private volatile @Nullable Thread currentReceiveThread;

        private AsyncMessageListenerInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean surplus;
            DefaultMessageListenerContainer.this.lifecycleLock.lock();
            try {
                surplus = DefaultMessageListenerContainer.this.scheduledInvokers.size() > DefaultMessageListenerContainer.this.concurrentConsumers;
                ++DefaultMessageListenerContainer.this.activeInvokerCount;
                DefaultMessageListenerContainer.this.lifecycleCondition.signalAll();
            }
            finally {
                DefaultMessageListenerContainer.this.lifecycleLock.unlock();
            }
            boolean messageReceived = false;
            try {
                int messageLimit = DefaultMessageListenerContainer.this.maxMessagesPerTask;
                int idleLimit = DefaultMessageListenerContainer.this.idleReceivesPerTaskLimit;
                if (!(messageLimit >= 0 || surplus && idleLimit >= 0)) {
                    messageReceived = this.executeOngoingLoop();
                } else {
                    int idleCount = 0;
                    for (int messageCount = 0; !(!DefaultMessageListenerContainer.this.isRunning() || messageLimit >= 0 && messageCount >= messageLimit || idleLimit >= 0 && idleCount >= idleLimit); ++messageCount) {
                        boolean currentReceived = this.invokeListener();
                        messageReceived |= currentReceived;
                        idleCount = currentReceived ? 0 : idleCount + 1;
                    }
                }
            }
            catch (Throwable ex) {
                this.clearResources();
                if (!this.lastMessageSucceeded) {
                    this.waitBeforeRecoveryAttempt();
                }
                this.lastMessageSucceeded = false;
                boolean alreadyRecovered = false;
                DefaultMessageListenerContainer.this.recoveryLock.lock();
                try {
                    if (this.lastRecoveryMarker == DefaultMessageListenerContainer.this.currentRecoveryMarker) {
                        DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, false);
                        DefaultMessageListenerContainer.this.recoverAfterListenerSetupFailure();
                        DefaultMessageListenerContainer.this.currentRecoveryMarker = new Object();
                    } else {
                        alreadyRecovered = true;
                    }
                }
                finally {
                    DefaultMessageListenerContainer.this.recoveryLock.unlock();
                }
                if (alreadyRecovered) {
                    DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, true);
                }
            }
            finally {
                DefaultMessageListenerContainer.this.lifecycleLock.lock();
                try {
                    this.decreaseActiveInvokerCount();
                    DefaultMessageListenerContainer.this.lifecycleCondition.signalAll();
                }
                finally {
                    DefaultMessageListenerContainer.this.lifecycleLock.unlock();
                }
                this.idleTaskExecutionCount = !messageReceived ? ++this.idleTaskExecutionCount : 0;
                DefaultMessageListenerContainer.this.lifecycleLock.lock();
                try {
                    if (!DefaultMessageListenerContainer.this.shouldRescheduleInvoker(this.idleTaskExecutionCount) || !DefaultMessageListenerContainer.this.rescheduleTaskIfNecessary(this)) {
                        DefaultMessageListenerContainer.this.scheduledInvokers.remove(this);
                        if (DefaultMessageListenerContainer.this.logger.isDebugEnabled()) {
                            DefaultMessageListenerContainer.this.logger.debug((Object)("Lowered scheduled invoker count: " + DefaultMessageListenerContainer.this.scheduledInvokers.size()));
                        }
                        DefaultMessageListenerContainer.this.lifecycleCondition.signalAll();
                        this.clearResources();
                    } else if (DefaultMessageListenerContainer.this.isRunning()) {
                        int nonPausedConsumers = DefaultMessageListenerContainer.this.getScheduledConsumerCount() - DefaultMessageListenerContainer.this.getPausedTaskCount();
                        if (nonPausedConsumers < 1) {
                            DefaultMessageListenerContainer.this.logger.error((Object)"All scheduled consumers have been paused, probably due to tasks having been rejected. Check your thread pool configuration! Manual recovery necessary through a start() call.");
                        } else if (nonPausedConsumers < DefaultMessageListenerContainer.this.getConcurrentConsumers()) {
                            DefaultMessageListenerContainer.this.logger.warn((Object)"Number of scheduled consumers has dropped below concurrentConsumers limit, probably due to tasks having been rejected. Check your thread pool configuration! Automatic recovery to be triggered by remaining consumers.");
                        }
                    }
                }
                finally {
                    DefaultMessageListenerContainer.this.lifecycleLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeOngoingLoop() throws JMSException {
            boolean messageReceived = false;
            boolean active = true;
            while (active) {
                DefaultMessageListenerContainer.this.lifecycleLock.lock();
                try {
                    boolean interrupted = false;
                    boolean wasWaiting = false;
                    while ((active = DefaultMessageListenerContainer.this.isActive()) && !DefaultMessageListenerContainer.this.isRunning()) {
                        if (interrupted) {
                            throw new IllegalStateException("Thread was interrupted while waiting for a restart of the listener container, but container is still stopped");
                        }
                        if (!wasWaiting) {
                            this.decreaseActiveInvokerCount();
                        }
                        wasWaiting = true;
                        try {
                            DefaultMessageListenerContainer.this.lifecycleCondition.await();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            interrupted = true;
                        }
                    }
                    if (wasWaiting) {
                        ++DefaultMessageListenerContainer.this.activeInvokerCount;
                    }
                    if (DefaultMessageListenerContainer.this.scheduledInvokers.size() > DefaultMessageListenerContainer.this.maxConcurrentConsumers) {
                        active = false;
                    }
                }
                finally {
                    DefaultMessageListenerContainer.this.lifecycleLock.unlock();
                }
                if (!active) continue;
                messageReceived = this.invokeListener() || messageReceived;
            }
            return messageReceived;
        }

        private boolean invokeListener() throws JMSException {
            this.currentReceiveThread = Thread.currentThread();
            try {
                this.initResourcesIfNecessary();
                boolean messageReceived = DefaultMessageListenerContainer.this.receiveAndExecute(this, this.session, this.consumer);
                this.lastMessageSucceeded = true;
                boolean bl = messageReceived;
                return bl;
            }
            finally {
                this.currentReceiveThread = null;
            }
        }

        private void decreaseActiveInvokerCount() {
            --DefaultMessageListenerContainer.this.activeInvokerCount;
            if (DefaultMessageListenerContainer.this.activeInvokerCount == 0) {
                if (!DefaultMessageListenerContainer.this.isRunning()) {
                    DefaultMessageListenerContainer.this.releaseSharedConnection();
                }
                if (DefaultMessageListenerContainer.this.stopCallback != null) {
                    DefaultMessageListenerContainer.this.stopCallback.run();
                    DefaultMessageListenerContainer.this.stopCallback = null;
                }
            }
        }

        private void initResourcesIfNecessary() throws JMSException {
            if (DefaultMessageListenerContainer.this.getCacheLevel() <= 1) {
                this.updateRecoveryMarker();
            } else {
                if (this.session == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 2) {
                    this.updateRecoveryMarker();
                    this.session = DefaultMessageListenerContainer.this.createSession(DefaultMessageListenerContainer.this.getSharedConnection());
                }
                if (this.consumer == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 3) {
                    this.consumer = DefaultMessageListenerContainer.this.createListenerConsumer(this.session);
                    DefaultMessageListenerContainer.this.lifecycleLock.lock();
                    try {
                        ++DefaultMessageListenerContainer.this.registeredWithDestination;
                    }
                    finally {
                        DefaultMessageListenerContainer.this.lifecycleLock.unlock();
                    }
                }
            }
        }

        private void updateRecoveryMarker() {
            DefaultMessageListenerContainer.this.recoveryLock.lock();
            try {
                this.lastRecoveryMarker = DefaultMessageListenerContainer.this.currentRecoveryMarker;
            }
            finally {
                DefaultMessageListenerContainer.this.recoveryLock.unlock();
            }
        }

        private void interruptIfNecessary() {
            Thread currentReceiveThread = this.currentReceiveThread;
            if (currentReceiveThread != null && !currentReceiveThread.isInterrupted()) {
                currentReceiveThread.interrupt();
            }
        }

        private void clearResources() {
            if (DefaultMessageListenerContainer.this.sharedConnectionEnabled()) {
                DefaultMessageListenerContainer.this.sharedConnectionLock.lock();
                try {
                    JmsUtils.closeMessageConsumer(this.consumer);
                    JmsUtils.closeSession(this.session);
                }
                finally {
                    DefaultMessageListenerContainer.this.sharedConnectionLock.unlock();
                }
            } else {
                JmsUtils.closeMessageConsumer(this.consumer);
                JmsUtils.closeSession(this.session);
            }
            if (this.consumer != null) {
                DefaultMessageListenerContainer.this.lifecycleLock.lock();
                try {
                    --DefaultMessageListenerContainer.this.registeredWithDestination;
                }
                finally {
                    DefaultMessageListenerContainer.this.lifecycleLock.unlock();
                }
            }
            this.consumer = null;
            this.session = null;
        }

        private void waitBeforeRecoveryAttempt() {
            BackOffExecution execution = DefaultMessageListenerContainer.this.backOff.start();
            DefaultMessageListenerContainer.this.applyBackOffTime(execution);
        }

        public boolean isLongLived() {
            return DefaultMessageListenerContainer.this.maxMessagesPerTask < 0;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
        }

        public boolean isIdle() {
            return this.idle;
        }
    }
}

