/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.config.AbstractJmsListenerContainerFactory;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.backoff.BackOff;

public class DefaultJmsListenerContainerFactory
extends AbstractJmsListenerContainerFactory<DefaultMessageListenerContainer> {
    private @Nullable Executor taskExecutor;
    private @Nullable PlatformTransactionManager transactionManager;
    private @Nullable Integer cacheLevel;
    private @Nullable String cacheLevelName;
    private @Nullable String concurrency;
    private @Nullable Integer maxMessagesPerTask;
    private @Nullable Long receiveTimeout;
    private @Nullable Long recoveryInterval;
    private @Nullable BackOff backOff;

    public void setTaskExecutor(@Nullable Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionManager(@Nullable PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setCacheLevel(@Nullable Integer cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public void setCacheLevelName(@Nullable String cacheLevelName) {
        this.cacheLevelName = cacheLevelName;
    }

    public void setConcurrency(@Nullable String concurrency) {
        this.concurrency = concurrency;
    }

    public void setMaxMessagesPerTask(@Nullable Integer maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public void setReceiveTimeout(@Nullable Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setRecoveryInterval(@Nullable Long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setBackOff(@Nullable BackOff backOff) {
        this.backOff = backOff;
    }

    @Override
    protected DefaultMessageListenerContainer createContainerInstance() {
        return new DefaultMessageListenerContainer();
    }

    @Override
    protected void initializeContainer(DefaultMessageListenerContainer container) {
        if (this.taskExecutor != null) {
            container.setTaskExecutor(this.taskExecutor);
        }
        if (this.transactionManager != null) {
            container.setTransactionManager(this.transactionManager);
        }
        if (this.cacheLevel != null) {
            container.setCacheLevel(this.cacheLevel);
        } else if (this.cacheLevelName != null) {
            container.setCacheLevelName(this.cacheLevelName);
        }
        if (this.concurrency != null) {
            container.setConcurrency(this.concurrency);
        }
        if (this.maxMessagesPerTask != null) {
            container.setMaxMessagesPerTask(this.maxMessagesPerTask);
        }
        if (this.receiveTimeout != null) {
            container.setReceiveTimeout(this.receiveTimeout);
        }
        if (this.backOff != null) {
            container.setBackOff(this.backOff);
            if (this.recoveryInterval != null) {
                this.logger.info((Object)"Ignoring recovery interval in DefaultJmsListenerContainerFactory in favor of BackOff");
            }
        } else if (this.recoveryInterval != null) {
            container.setRecoveryInterval(this.recoveryInterval);
        }
    }
}

