/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.TypedValue;

public interface EvaluationContext {
    public TypedValue getRootObject();

    default public List<PropertyAccessor> getPropertyAccessors() {
        return Collections.emptyList();
    }

    default public List<IndexAccessor> getIndexAccessors() {
        return Collections.emptyList();
    }

    default public List<ConstructorResolver> getConstructorResolvers() {
        return Collections.emptyList();
    }

    default public List<MethodResolver> getMethodResolvers() {
        return Collections.emptyList();
    }

    public @Nullable BeanResolver getBeanResolver();

    public TypeLocator getTypeLocator();

    public TypeConverter getTypeConverter();

    public TypeComparator getTypeComparator();

    public OperatorOverloader getOperatorOverloader();

    default public TypedValue assignVariable(String name, Supplier<TypedValue> valueSupplier) {
        TypedValue typedValue = valueSupplier.get();
        this.setVariable(name, typedValue.getValue());
        return typedValue;
    }

    public void setVariable(String var1, @Nullable Object var2);

    public @Nullable Object lookupVariable(String var1);

    default public boolean isAssignmentEnabled() {
        return true;
    }
}

