/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.MessageCodesResolver;

public class DataBinder
implements PropertyEditorRegistry {
    public static final String DEFAULT_OBJECT_NAME = "target";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$validation$DataBinder == null ? (class$org$springframework$validation$DataBinder = DataBinder.class$("org.springframework.validation.DataBinder")) : class$org$springframework$validation$DataBinder));
    private final BindException errors;
    private boolean ignoreUnknownFields = true;
    private String[] allowedFields;
    private String[] requiredFields;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    static /* synthetic */ Class class$org$springframework$validation$DataBinder;

    public DataBinder(Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(Object target, String objectName) {
        this.errors = this.createErrors(target, objectName);
        this.setExtractOldValueForEditor(true);
    }

    protected BindException createErrors(Object target, String objectName) {
        return new BindException(target, objectName);
    }

    public Object getTarget() {
        return this.errors.getTarget();
    }

    public String getObjectName() {
        return this.errors.getObjectName();
    }

    public BindException getErrors() {
        return this.errors;
    }

    protected BeanWrapper getBeanWrapper() {
        return this.errors.getBeanWrapper();
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setAllowedFields(String[] allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])allowedFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder restricted to binding allowed fields [" + StringUtils.arrayToCommaDelimitedString((Object[])allowedFields) + "]"));
        }
    }

    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setRequiredFields(String[] requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString((Object[])requiredFields) + "]"));
        }
    }

    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.errors.getBeanWrapper().setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.errors.getBeanWrapper().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String field, PropertyEditor propertyEditor) {
        this.getBeanWrapper().registerCustomEditor(requiredType, field, propertyEditor);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        return this.getBeanWrapper().findCustomEditor(requiredType, propertyPath);
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.errors.setMessageCodesResolver(messageCodesResolver);
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void bind(PropertyValues pvs) {
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (MutablePropertyValues)pvs : new MutablePropertyValues(pvs);
        this.doBind(mpvs);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkAllowedFields(mpvs);
        this.checkRequiredFields(mpvs);
        this.applyPropertyValues(mpvs);
    }

    protected void checkAllowedFields(MutablePropertyValues mpvs) {
        List<String> allowedFieldsList = this.getAllowedFields() != null ? Arrays.asList(this.getAllowedFields()) : null;
        PropertyValue[] pvs = mpvs.getPropertyValues();
        for (int i = 0; i < pvs.length; ++i) {
            PropertyValue pv = pvs[i];
            String field = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
            if (allowedFieldsList != null && allowedFieldsList.contains(field) || this.isAllowed(field)) continue;
            mpvs.removePropertyValue(pv);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Field [" + field + "] has been removed from PropertyValues " + "and will not be bound, because it has not been found in the list of allowed fields " + allowedFieldsList));
        }
    }

    protected boolean isAllowed(String field) {
        if (this.getAllowedFields() != null) {
            String[] allowedFields = this.getAllowedFields();
            for (int i = 0; i < allowedFields.length; ++i) {
                String allowed = allowedFields[i];
                if ((!allowed.endsWith("*") || !field.startsWith(allowed.substring(0, allowed.length() - 1))) && (!allowed.startsWith("*") || !field.endsWith(allowed.substring(1, allowed.length())))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void checkRequiredFields(MutablePropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (!ObjectUtils.isEmpty((Object[])requiredFields)) {
            int i;
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            PropertyValue[] pvs = mpvs.getPropertyValues();
            for (i = 0; i < pvs.length; ++i) {
                PropertyValue pv = pvs[i];
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
                propertyValues.put(canonicalName, pv);
            }
            for (i = 0; i < requiredFields.length; ++i) {
                Object field = requiredFields[i];
                PropertyValue pv = (PropertyValue)propertyValues.get(field);
                if (pv != null && pv.getValue() != null && (!(pv.getValue() instanceof String) || StringUtils.hasText((String)((String)pv.getValue())))) continue;
                this.getBindingErrorProcessor().processMissingFieldError((String)field, this.getErrors());
                if (pv == null) continue;
                mpvs.removePropertyValue(pv);
                propertyValues.remove(field);
            }
        }
    }

    protected void applyPropertyValues(MutablePropertyValues mpvs) {
        try {
            this.getBeanWrapper().setPropertyValues((PropertyValues)mpvs, this.isIgnoreUnknownFields());
        }
        catch (PropertyAccessExceptionsException ex) {
            PropertyAccessException[] exs = ex.getPropertyAccessExceptions();
            for (int i = 0; i < exs.length; ++i) {
                this.getBindingErrorProcessor().processPropertyAccessException(exs[i], this.getErrors());
            }
        }
    }

    public Map close() throws BindException {
        if (this.getErrors().hasErrors()) {
            throw this.getErrors();
        }
        return this.getErrors().getModel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

