/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResult;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.jcache.interceptor.AbstractJCacheKeyOperation;
import org.springframework.util.ExceptionTypeFilter;
import org.springframework.util.StringUtils;

class CacheResultOperation
extends AbstractJCacheKeyOperation<CacheResult> {
    private final ExceptionTypeFilter exceptionTypeFilter;
    private final @Nullable CacheResolver exceptionCacheResolver;
    private final @Nullable String exceptionCacheName;

    public CacheResultOperation(CacheMethodDetails<CacheResult> methodDetails, CacheResolver cacheResolver, KeyGenerator keyGenerator, @Nullable CacheResolver exceptionCacheResolver) {
        super(methodDetails, cacheResolver, keyGenerator);
        CacheResult ann = (CacheResult)methodDetails.getCacheAnnotation();
        this.exceptionTypeFilter = this.createExceptionTypeFilter(ann.cachedExceptions(), ann.nonCachedExceptions());
        this.exceptionCacheResolver = exceptionCacheResolver;
        this.exceptionCacheName = StringUtils.hasText((String)ann.exceptionCacheName()) ? ann.exceptionCacheName() : null;
    }

    @Override
    public ExceptionTypeFilter getExceptionTypeFilter() {
        return this.exceptionTypeFilter;
    }

    public boolean isAlwaysInvoked() {
        return ((CacheResult)this.getCacheAnnotation()).skipGet();
    }

    public @Nullable CacheResolver getExceptionCacheResolver() {
        return this.exceptionCacheResolver;
    }

    public @Nullable String getExceptionCacheName() {
        return this.exceptionCacheName;
    }
}

