/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;

class DisposableBeanAdapter
implements DisposableBean,
Runnable,
Serializable {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$support$DisposableBeanAdapter == null ? (class$org$springframework$beans$factory$support$DisposableBeanAdapter = DisposableBeanAdapter.class$("org.springframework.beans.factory.support.DisposableBeanAdapter")) : class$org$springframework$beans$factory$support$DisposableBeanAdapter));
    private final Object bean;
    private final String beanName;
    private final String destroyMethodName;
    private final boolean enforceDestroyMethod;
    private List beanPostProcessors;
    static /* synthetic */ Class class$org$springframework$beans$factory$support$DisposableBeanAdapter;

    public DisposableBeanAdapter(Object bean, String beanName, RootBeanDefinition beanDefinition, List postProcessors) {
        Assert.notNull((Object)bean, (String)"Bean must not be null");
        this.bean = bean;
        this.beanName = beanName;
        this.destroyMethodName = beanDefinition.getDestroyMethodName();
        this.enforceDestroyMethod = beanDefinition.isEnforceDestroyMethod();
        this.beanPostProcessors = this.filterPostProcessors(postProcessors);
    }

    private DisposableBeanAdapter(Object bean, String beanName, String destroyMethodName, boolean enforceDestroyMethod, List postProcessors) {
        this.bean = bean;
        this.beanName = beanName;
        this.destroyMethodName = destroyMethodName;
        this.enforceDestroyMethod = enforceDestroyMethod;
        this.beanPostProcessors = postProcessors;
    }

    private List filterPostProcessors(List postProcessors) {
        ArrayList filteredPostProcessors = null;
        if (postProcessors != null && !postProcessors.isEmpty()) {
            filteredPostProcessors = new ArrayList(postProcessors.size());
            Iterator it = postProcessors.iterator();
            while (it.hasNext()) {
                Object postProcessor = it.next();
                if (!(postProcessor instanceof DestructionAwareBeanPostProcessor)) continue;
                filteredPostProcessors.add(postProcessor);
            }
        }
        return filteredPostProcessors;
    }

    public void run() {
        this.destroy();
    }

    public void destroy() {
        if (this.beanPostProcessors != null && !this.beanPostProcessors.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + this.beanName + "'"));
            }
            for (int i = this.beanPostProcessors.size() - 1; i >= 0; --i) {
                ((DestructionAwareBeanPostProcessor)this.beanPostProcessors.get(i)).postProcessBeforeDestruction(this.bean, this.beanName);
            }
        }
        if (this.bean instanceof DisposableBean) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking destroy() on bean with name '" + this.beanName + "'"));
            }
            try {
                ((DisposableBean)this.bean).destroy();
            }
            catch (Throwable ex) {
                logger.error((Object)("Couldn't invoke destroy method of bean with name '" + this.beanName + "'"), ex);
            }
        }
        if (this.destroyMethodName != null) {
            this.invokeCustomDestroyMethod();
        }
    }

    private void invokeCustomDestroyMethod() {
        if (this.destroyMethodName != null) {
            try {
                Method destroyMethod = BeanUtils.findMethodWithMinimalParameters(this.bean.getClass(), this.destroyMethodName);
                if (destroyMethod == null) {
                    if (this.enforceDestroyMethod) {
                        logger.error((Object)("Couldn't find a destroy method named '" + this.destroyMethodName + "' on bean with name '" + this.beanName + "'"));
                    }
                } else {
                    Class<?>[] paramTypes = destroyMethod.getParameterTypes();
                    if (paramTypes.length > 1) {
                        logger.error((Object)("Method '" + this.destroyMethodName + "' of bean '" + this.beanName + "' has more than one parameter - not supported as destroy method"));
                    } else if (paramTypes.length == 1 && !paramTypes[0].equals(Boolean.TYPE)) {
                        logger.error((Object)("Method '" + this.destroyMethodName + "' of bean '" + this.beanName + "' has a non-boolean parameter - not supported as destroy method"));
                    } else {
                        Object[] args = new Object[paramTypes.length];
                        if (paramTypes.length == 1) {
                            args[0] = Boolean.TRUE;
                        }
                        if (!Modifier.isPublic(destroyMethod.getModifiers()) || !Modifier.isPublic(destroyMethod.getDeclaringClass().getModifiers())) {
                            destroyMethod.setAccessible(true);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invoking custom destroy method on bean with name '" + this.beanName + "'"));
                        }
                        try {
                            destroyMethod.invoke(this.bean, args);
                        }
                        catch (InvocationTargetException ex) {
                            logger.error((Object)("Couldn't invoke destroy method '" + this.destroyMethodName + "' of bean with name '" + this.beanName + "'"), ex.getTargetException());
                        }
                        catch (Throwable ex) {
                            logger.error((Object)("Couldn't invoke destroy method '" + this.destroyMethodName + "' of bean with name '" + this.beanName + "'"), ex);
                        }
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                logger.error((Object)("Couldn't find a unique destroy method on bean with name '" + this.beanName + ": " + ex.getMessage()));
            }
        }
    }

    protected Object writeReplace() {
        ArrayList serializablePostProcessors = null;
        if (this.beanPostProcessors != null) {
            serializablePostProcessors = new ArrayList();
            Iterator it = this.beanPostProcessors.iterator();
            while (it.hasNext()) {
                Object postProcessor = it.next();
                if (!(postProcessor instanceof Serializable)) continue;
                serializablePostProcessors.add(postProcessor);
            }
        }
        return new DisposableBeanAdapter(this.bean, this.beanName, this.destroyMethodName, this.enforceDestroyMethod, serializablePostProcessors);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

