/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.DuplicateStatusException;
import org.springframework.social.ExpiredAuthorizationException;
import org.springframework.social.InsufficientPermissionException;
import org.springframework.social.InvalidAuthorizationException;
import org.springframework.social.RateLimitExceededException;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.RevokedAuthorizationException;
import org.springframework.social.ServerException;
import org.springframework.social.UncategorizedApiException;
import org.springframework.social.facebook.api.FacebookError;
import org.springframework.social.facebook.api.FacebookErrors;
import org.springframework.web.client.DefaultResponseErrorHandler;

class FacebookErrorHandler
extends DefaultResponseErrorHandler {
    private static final String FACEBOOK_PROVIDER_ID = "facebook";
    private static final Log logger = LogFactory.getLog(FacebookErrorHandler.class);

    FacebookErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        FacebookError error = this.extractErrorFromResponse(response);
        this.handleFacebookError(response.getStatusCode(), error);
    }

    void handleFacebookError(HttpStatus statusCode, FacebookError error) {
        if (error != null && error.getCode() != null) {
            int code = error.getCode();
            if (code == 1) {
                throw new UncategorizedApiException(FACEBOOK_PROVIDER_ID, error.getMessage(), null);
            }
            if (code == 2) {
                throw new ServerException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            if (code == 4 || code == 17 || code == 340 || code == 341) {
                throw new RateLimitExceededException(FACEBOOK_PROVIDER_ID);
            }
            if (code == 10 || FacebookErrors.isUserPermissionError(code)) {
                throw new InsufficientPermissionException(FACEBOOK_PROVIDER_ID);
            }
            if (code == 102 || code == 104) {
                throw new InvalidAuthorizationException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            if (code == 190 && error.getSubcode() == null) {
                throw new InvalidAuthorizationException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            if (code == 190 && error.getSubcode() == 463) {
                throw new ExpiredAuthorizationException(FACEBOOK_PROVIDER_ID);
            }
            if (code == 190) {
                throw new RevokedAuthorizationException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            if (code == 506) {
                throw new DuplicateStatusException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            if (code == 803 || code == 2500) {
                throw new ResourceNotFoundException(FACEBOOK_PROVIDER_ID, error.getMessage());
            }
            throw new UncategorizedApiException(FACEBOOK_PROVIDER_ID, error.getMessage(), null);
        }
    }

    private FacebookError extractErrorFromResponse(ClientHttpResponse response) throws IOException {
        String json = this.readResponseJson(response);
        try {
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            JsonNode jsonNode = (JsonNode)mapper.readValue(json, JsonNode.class);
            if (jsonNode.has("error")) {
                JsonNode errorNode = jsonNode.get("error");
                Integer code = errorNode.has("code") ? Integer.valueOf(errorNode.get("code").intValue()) : null;
                String type = errorNode.has("type") ? errorNode.get("type").asText() : null;
                String message = errorNode.has("message") ? errorNode.get("message").asText() : null;
                Integer subcode = errorNode.has("error_subcode") ? Integer.valueOf(errorNode.get("error_subcode").intValue()) : null;
                String userMessage = errorNode.has("error_user_msg") ? errorNode.get("error_user_msg").asText() : null;
                String userTitle = errorNode.has("error_user_title") ? errorNode.get("error_user_title").asText() : null;
                FacebookError error = new FacebookError(code, type, message, subcode, userMessage, userTitle);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Facebook error: ");
                    logger.debug((Object)("   CODE        : " + error.getCode()));
                    logger.debug((Object)("   TYPE        : " + error.getType()));
                    logger.debug((Object)("   SUBCODE     : " + error.getSubcode()));
                    logger.debug((Object)("   MESSAGE     : " + error.getMessage()));
                    logger.debug((Object)("   USER TITLE  : " + error.getUserTitle()));
                    logger.debug((Object)("   USER MESSAGE: " + error.getUserMessage()));
                }
                return error;
            }
        }
        catch (JsonParseException e) {
            return null;
        }
        return null;
    }

    private String readResponseJson(ClientHttpResponse response) throws IOException {
        String json = this.readFully(response.getBody());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Error from Facebook: " + json));
        }
        return json;
    }

    private String readFully(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            sb.append(reader.readLine());
        }
        return sb.toString();
    }
}

