/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public abstract class AbstractConnectionRepositoryConfigSupport {
    private static final Log logger = LogFactory.getLog(AbstractConnectionRepositoryConfigSupport.class);
    private static final String CREATE_CONNECTION_REPOSITORY_METHOD_NAME = "createConnectionRepository";

    protected BeanDefinition registerConnectionRepository(BeanDefinitionRegistry registry, String usersConnectionRepositoryId, String connectionRepositoryId, String userIdSourceRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering ConnectionRepository bean");
        }
        AbstractBeanDefinition connectionRepositoryBD = BeanDefinitionBuilder.genericBeanDefinition().addConstructorArgValue((Object)("#{" + userIdSourceRef + ".userId}")).getBeanDefinition();
        connectionRepositoryBD.setFactoryBeanName(usersConnectionRepositoryId);
        connectionRepositoryBD.setFactoryMethodName(CREATE_CONNECTION_REPOSITORY_METHOD_NAME);
        connectionRepositoryBD.setScope("request");
        registry.registerBeanDefinition(connectionRepositoryId, this.decorateWithScopedProxy(connectionRepositoryId, (BeanDefinition)connectionRepositoryBD, registry));
        return connectionRepositoryBD;
    }

    protected BeanDefinition decorateWithScopedProxy(String beanName, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
        return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)registry, (boolean)false).getBeanDefinition();
    }
}

