/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.query.extractor.ValueCollector;
import com.hazelcast.query.extractor.ValueExtractor;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalNameExtractor
extends ValueExtractor<MapSession, String> {
    private static final PrincipalNameResolver PRINCIPAL_NAME_RESOLVER = new PrincipalNameResolver();

    public void extract(MapSession target, String argument, ValueCollector collector) {
        String principalName = PRINCIPAL_NAME_RESOLVER.resolvePrincipal(target);
        if (principalName != null) {
            collector.addObject((Object)principalName);
        }
    }

    static class PrincipalNameResolver {
        private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
        private SpelExpressionParser parser = new SpelExpressionParser();

        PrincipalNameResolver() {
        }

        public String resolvePrincipal(Session session) {
            String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName != null) {
                return principalName;
            }
            Object authentication = session.getAttribute(SPRING_SECURITY_CONTEXT);
            if (authentication != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                return (String)expression.getValue(authentication, String.class);
            }
            return null;
        }
    }
}

