/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class OncePerRequestFilter
implements Filter {
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    private String alreadyFilteredAttributeName = this.getClass().getName().concat(".FILTERED");

    OncePerRequestFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean hasAlreadyFilteredAttribute;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("OncePerRequestFilter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(this.alreadyFilteredAttributeName) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
        } else {
            request.setAttribute(this.alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            try {
                this.doFilterInternal(httpRequest, httpResponse, filterChain);
            }
            finally {
                request.removeAttribute(this.alreadyFilteredAttributeName);
            }
        }
    }

    protected abstract void doFilterInternal(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

