/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public final class JdbcSchemaUtils {
    private JdbcSchemaUtils() {
    }

    public static Resource replaceDefaultTableName(Resource schemaResource, String tableName) throws IOException {
        try (InputStream inputStream = schemaResource.getInputStream();){
            String schemaScript = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            String newSchema = schemaScript.replace("SPRING_SESSION", tableName);
            ByteArrayResource byteArrayResource = new ByteArrayResource(newSchema.getBytes(StandardCharsets.UTF_8));
            return byteArrayResource;
        }
    }
}

