/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.session.MapSession;
import org.springframework.util.Assert;

public final class RedisSessionMapper
implements BiFunction<String, Map<String, Object>, MapSession> {
    static final String CREATION_TIME_KEY = "creationTime";
    static final String LAST_ACCESSED_TIME_KEY = "lastAccessedTime";
    static final String MAX_INACTIVE_INTERVAL_KEY = "maxInactiveInterval";
    static final String ATTRIBUTE_PREFIX = "sessionAttr:";

    private static void handleMissingKey(String key) {
        throw new IllegalStateException(key + " key must not be null");
    }

    @Override
    public MapSession apply(String sessionId, Map<String, Object> map) {
        Assert.hasText((String)sessionId, (String)"sessionId must not be empty");
        Assert.notEmpty(map, (String)"map must not be empty");
        MapSession session = new MapSession(sessionId);
        Long creationTime = (Long)map.get(CREATION_TIME_KEY);
        if (creationTime == null) {
            RedisSessionMapper.handleMissingKey(CREATION_TIME_KEY);
        }
        session.setCreationTime(Instant.ofEpochMilli(creationTime));
        Long lastAccessedTime = (Long)map.get(LAST_ACCESSED_TIME_KEY);
        if (lastAccessedTime == null) {
            RedisSessionMapper.handleMissingKey(LAST_ACCESSED_TIME_KEY);
        }
        session.setLastAccessedTime(Instant.ofEpochMilli(lastAccessedTime));
        Integer maxInactiveInterval = (Integer)map.get(MAX_INACTIVE_INTERVAL_KEY);
        if (maxInactiveInterval == null) {
            RedisSessionMapper.handleMissingKey(MAX_INACTIVE_INTERVAL_KEY);
        }
        session.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveInterval.intValue()));
        map.forEach((name, value) -> {
            if (name.startsWith(ATTRIBUTE_PREFIX)) {
                session.setAttribute(name.substring(ATTRIBUTE_PREFIX.length()), value);
            }
        });
        return session;
    }
}

