/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.session.DelegatingIndexResolver;
import org.springframework.session.IndexResolver;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.Session;
import org.springframework.session.data.redis.ReactiveRedisIndexedSessionRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

final class ReactiveRedisSessionIndexer {
    private final ReactiveRedisOperations<String, Object> sessionRedisOperations;
    private String namespace;
    private IndexResolver<Session> indexResolver = new DelegatingIndexResolver(new IndexResolver[]{new PrincipalNameIndexResolver("PRINCIPAL_NAME_INDEX_NAME")});
    private String indexKeyPrefix;

    ReactiveRedisSessionIndexer(ReactiveRedisOperations<String, Object> sessionRedisOperations, String namespace) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        Assert.hasText((String)namespace, (String)"namespace cannot be empty");
        this.sessionRedisOperations = sessionRedisOperations;
        this.namespace = namespace;
        this.updateIndexKeyPrefix();
    }

    Mono<Void> update(ReactiveRedisIndexedSessionRepository.RedisSession redisSession) {
        return this.getIndexes(redisSession.getId()).map(originalIndexes -> {
            Map indexes = this.indexResolver.resolveIndexesFor((Session)redisSession);
            HashMap<String, String> indexToDelete = new HashMap<String, String>();
            HashMap<String, String> indexToAdd = new HashMap<String, String>();
            for (Map.Entry entry : indexes.entrySet()) {
                if (!originalIndexes.containsKey(entry.getKey())) {
                    indexToAdd.put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (((String)originalIndexes.get(entry.getKey())).equals(entry.getValue())) continue;
                indexToDelete.put((String)entry.getKey(), (String)originalIndexes.get(entry.getKey()));
                indexToAdd.put((String)entry.getKey(), (String)entry.getValue());
            }
            if (CollectionUtils.isEmpty((Map)indexes) && !CollectionUtils.isEmpty((Map)originalIndexes)) {
                indexToDelete.putAll((Map<String, String>)originalIndexes);
            }
            return Tuples.of(indexToDelete, indexToAdd);
        }).flatMap(indexes -> this.updateIndexes((Map)indexes.getT1(), (Map)indexes.getT2(), redisSession.getId()));
    }

    private Mono<Void> updateIndexes(Map<String, String> indexToDelete, Map<String, String> indexToAdd, String sessionId) {
        return Flux.fromIterable(indexToDelete.entrySet()).flatMap(entry -> {
            String indexKey = this.getIndexKey((String)entry.getKey(), (String)entry.getValue());
            return this.removeSessionFromIndex(indexKey, sessionId).thenReturn((Object)indexKey);
        }).flatMap(indexKey -> this.sessionRedisOperations.opsForSet().remove((Object)this.getSessionIndexesKey(sessionId), new Object[]{indexKey})).thenMany((Publisher)Flux.fromIterable(indexToAdd.entrySet())).flatMap(entry -> {
            String indexKey = this.getIndexKey((String)entry.getKey(), (String)entry.getValue());
            return this.sessionRedisOperations.opsForSet().add((Object)indexKey, new Object[]{sessionId}).thenReturn((Object)indexKey);
        }).flatMap(indexKey -> this.sessionRedisOperations.opsForSet().add((Object)this.getSessionIndexesKey(sessionId), new Object[]{indexKey})).then();
    }

    Mono<Void> delete(String sessionId) {
        String sessionIndexesKey = this.getSessionIndexesKey(sessionId);
        return this.sessionRedisOperations.opsForSet().members((Object)sessionIndexesKey).flatMap(indexKey -> this.removeSessionFromIndex((String)indexKey, sessionId)).then(this.sessionRedisOperations.delete((Object[])new String[]{sessionIndexesKey})).then();
    }

    private Mono<Void> removeSessionFromIndex(String indexKey, String sessionId) {
        return this.sessionRedisOperations.opsForSet().remove((Object)indexKey, new Object[]{sessionId}).then();
    }

    Mono<Map<String, String>> getIndexes(String sessionId) {
        String sessionIndexesKey = this.getSessionIndexesKey(sessionId);
        return this.sessionRedisOperations.opsForSet().members((Object)sessionIndexesKey).cast(String.class).collectMap(indexKey -> indexKey.substring(this.indexKeyPrefix.length()).split(":")[0], indexKey -> indexKey.substring(this.indexKeyPrefix.length()).split(":")[1]);
    }

    Flux<String> getSessionIds(String indexName, String indexValue) {
        String indexKey = this.getIndexKey(indexName, indexValue);
        return this.sessionRedisOperations.opsForSet().members((Object)indexKey).cast(String.class);
    }

    private void updateIndexKeyPrefix() {
        this.indexKeyPrefix = this.namespace + "sessions:index:";
    }

    private String getSessionIndexesKey(String sessionId) {
        return this.namespace + "sessions:" + sessionId + ":idx";
    }

    private String getIndexKey(String indexName, String indexValue) {
        return this.indexKeyPrefix + indexName + ":" + indexValue;
    }

    void setNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be empty");
        this.namespace = namespace;
        this.updateIndexKeyPrefix();
    }

    void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexResolver = indexResolver;
    }
}

