/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactiveMongoSessionRepository
implements ReactiveSessionRepository<MongoSession>,
ApplicationEventPublisherAware,
InitializingBean {
    @Deprecated
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private static final Log logger = LogFactory.getLog(ReactiveMongoSessionRepository.class);
    private final ReactiveMongoOperations mongoOperations;
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(this.defaultMaxInactiveInterval);
    private MongoOperations blockingMongoOperations;
    private ApplicationEventPublisher eventPublisher;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    public ReactiveMongoSessionRepository(ReactiveMongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public Mono<MongoSession> createSession() {
        return Mono.fromSupplier(() -> this.sessionIdGenerator.generate()).zipWith(Mono.just((Object)this.defaultMaxInactiveInterval.toSeconds())).map(tuple -> new MongoSession((String)tuple.getT1(), (long)((Long)tuple.getT2()))).doOnNext(mongoSession -> mongoSession.setMaxInactiveInterval(this.defaultMaxInactiveInterval)).doOnNext(mongoSession -> mongoSession.setSessionIdGenerator(this.sessionIdGenerator)).doOnNext(mongoSession -> this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)mongoSession))).switchIfEmpty(Mono.just((Object)new MongoSession(this.sessionIdGenerator))).subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.parallel());
    }

    public Mono<Void> save(MongoSession session) {
        return Mono.justOrEmpty((Object)MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session)).flatMap(dbObject -> {
            if (session.hasChangedSessionId()) {
                return this.mongoOperations.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)session.getOriginalSessionId())), this.collectionName).then(this.mongoOperations.save(dbObject, this.collectionName));
            }
            return this.mongoOperations.save(dbObject, this.collectionName);
        }).then();
    }

    public Mono<MongoSession> findById(String id) {
        return this.findSession(id).map(document -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, document)).filter(mongoSession -> !mongoSession.isExpired()).doOnNext(mongoSession -> mongoSession.setSessionIdGenerator(this.sessionIdGenerator)).switchIfEmpty(Mono.defer(() -> this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        return this.findSession(id).flatMap(document -> this.mongoOperations.remove(document, this.collectionName).then(Mono.just((Object)document))).map(document -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, document)).doOnNext(mongoSession -> this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)mongoSession))).then();
    }

    public void afterPropertiesSet() {
        if (this.blockingMongoOperations != null) {
            IndexOperations indexOperations = this.blockingMongoOperations.indexOps(this.collectionName);
            this.mongoSessionConverter.ensureIndexes(indexOperations);
        }
    }

    private Mono<Document> findSession(String id) {
        return this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error((Object)("Error publishing " + String.valueOf(event) + "."), ex);
        }
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    @Deprecated(since="3.0.0")
    public void setMaxInactiveIntervalInSeconds(Integer defaultMaxInactiveInterval) {
        this.setDefaultMaxInactiveInterval(Duration.ofSeconds(defaultMaxInactiveInterval.intValue()));
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setBlockingMongoOperations(MongoOperations blockingMongoOperations) {
        this.blockingMongoOperations = blockingMongoOperations;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        Assert.notNull((Object)sessionIdGenerator, (String)"sessionIdGenerator cannot be null");
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

