/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.springframework.security.web.webauthn.api.COSEAlgorithmIdentifier;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;

public final class PublicKeyCredentialParameters {
    public static final PublicKeyCredentialParameters EdDSA = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.EdDSA);
    public static final PublicKeyCredentialParameters ES256 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.ES256);
    public static final PublicKeyCredentialParameters ES384 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.ES384);
    public static final PublicKeyCredentialParameters ES512 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.ES512);
    public static final PublicKeyCredentialParameters RS256 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.RS256);
    public static final PublicKeyCredentialParameters RS384 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.RS384);
    public static final PublicKeyCredentialParameters RS512 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.RS512);
    public static final PublicKeyCredentialParameters RS1 = new PublicKeyCredentialParameters(COSEAlgorithmIdentifier.RS1);
    private final PublicKeyCredentialType type;
    private final COSEAlgorithmIdentifier alg;

    private PublicKeyCredentialParameters(COSEAlgorithmIdentifier alg) {
        this(PublicKeyCredentialType.PUBLIC_KEY, alg);
    }

    private PublicKeyCredentialParameters(PublicKeyCredentialType type, COSEAlgorithmIdentifier alg) {
        this.type = type;
        this.alg = alg;
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }
}

