/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthUtils;
import org.springframework.security.web.authentication.www.NonceExpiredException;

public class DigestAuthenticationEntryPoint
implements AuthenticationEntryPoint,
InitializingBean,
Ordered {
    private static final Log logger = LogFactory.getLog(DigestAuthenticationEntryPoint.class);
    private String key;
    private String realmName;
    private int nonceValiditySeconds = 300;
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.realmName == null || "".equals(this.realmName)) {
            throw new IllegalArgumentException("realmName must be specified");
        }
        if (this.key == null || "".equals(this.key)) {
            throw new IllegalArgumentException("key must be specified");
        }
    }

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletResponse httpResponse = response;
        long expiryTime = System.currentTimeMillis() + (long)(this.nonceValiditySeconds * 1000);
        String signatureValue = DigestAuthUtils.md5Hex(expiryTime + ":" + this.key);
        String nonceValue = expiryTime + ":" + signatureValue;
        String nonceValueBase64 = new String(Base64.encode((byte[])nonceValue.getBytes()));
        String authenticateHeader = "Digest realm=\"" + this.realmName + "\", qop=\"auth\", nonce=\"" + nonceValueBase64 + "\"";
        if (authException instanceof NonceExpiredException) {
            authenticateHeader = authenticateHeader + ", stale=\"true\"";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WWW-Authenticate header sent to user agent: " + authenticateHeader));
        }
        httpResponse.addHeader("WWW-Authenticate", authenticateHeader);
        httpResponse.sendError(401, authException.getMessage());
    }

    public String getKey() {
        return this.key;
    }

    public int getNonceValiditySeconds() {
        return this.nonceValiditySeconds;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setNonceValiditySeconds(int nonceValiditySeconds) {
        this.nonceValiditySeconds = nonceValiditySeconds;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

