/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.aot.hint;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.util.ClassUtils;

class WebTestUtilsRuntimeHints
implements RuntimeHintsRegistrar {
    WebTestUtilsRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"jakarta.servlet.Filter", (ClassLoader)classLoader)) {
            return;
        }
        this.registerFilterChainProxyHints(hints);
        this.registerSecurityContextRepositoryHints(hints);
        this.registerCsrfTokenRepositoryHints(hints);
    }

    private void registerFilterChainProxyHints(RuntimeHints hints) {
        hints.reflection().registerType(FilterChainProxy.class, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.security.config.annotation.web.configuration.WebMvcSecurityConfiguration$CompositeFilterChainProxy"), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
        hints.reflection().registerType(TypeReference.of((String)"org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration$CompositeFilterChainProxy"), new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
    }

    private void registerCsrfTokenRepositoryHints(RuntimeHints hints) {
        hints.reflection().registerType(CsrfFilter.class, new MemberCategory[]{MemberCategory.ACCESS_DECLARED_FIELDS});
    }

    private void registerSecurityContextRepositoryHints(RuntimeHints hints) {
        hints.reflection().registerType(SecurityContextPersistenceFilter.class, new MemberCategory[]{MemberCategory.ACCESS_DECLARED_FIELDS});
        hints.reflection().registerType(SecurityContextHolderFilter.class, new MemberCategory[]{MemberCategory.ACCESS_DECLARED_FIELDS});
    }
}

