/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.server.resource.OAuth2ProtectedResourceMetadata;
import org.springframework.security.oauth2.server.resource.web.GenericHttpMessageConverterAdapter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2ProtectedResourceMetadataFilter
extends OncePerRequestFilter {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final GenericHttpMessageConverter<Object> JSON_MESSAGE_CONVERTER = HttpMessageConverters.getJsonMessageConverter();
    static final String DEFAULT_OAUTH2_PROTECTED_RESOURCE_METADATA_ENDPOINT_URI = "/.well-known/oauth-protected-resource";
    private final RequestMatcher requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/.well-known/oauth-protected-resource".concat("/**"));
    private Consumer<OAuth2ProtectedResourceMetadata.Builder> protectedResourceMetadataCustomizer = protectedResourceMetadata -> {};

    public void setProtectedResourceMetadataCustomizer(Consumer<OAuth2ProtectedResourceMetadata.Builder> protectedResourceMetadataCustomizer) {
        Assert.notNull(protectedResourceMetadataCustomizer, (String)"protectedResourceMetadataCustomizer cannot be null");
        this.protectedResourceMetadataCustomizer = protectedResourceMetadataCustomizer;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuth2ProtectedResourceMetadata.Builder builder = OAuth2ProtectedResourceMetadata.builder().resource(OAuth2ProtectedResourceMetadataFilter.resolveResourceIdentifier(request)).bearerMethod("header").tlsClientCertificateBoundAccessTokens(true);
        this.protectedResourceMetadataCustomizer.accept(builder);
        OAuth2ProtectedResourceMetadata protectedResourceMetadata = builder.build();
        try {
            ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
            JSON_MESSAGE_CONVERTER.write(protectedResourceMetadata.getClaims(), STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OAuth 2.0 Protected Resource Metadata: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static String resolveResourceIdentifier(HttpServletRequest request) {
        String path = request.getRequestURI();
        path = !StringUtils.hasText((String)path) ? "" : path.replace(DEFAULT_OAUTH2_PROTECTED_RESOURCE_METADATA_ENDPOINT_URI, "");
        return UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(path).replaceQuery(null).fragment(null).build().toUriString();
    }

    private static final class HttpMessageConverters {
        private static final boolean jacksonPresent;
        private static final boolean jackson2Present;
        private static final boolean gsonPresent;
        private static final boolean jsonbPresent;

        private HttpMessageConverters() {
        }

        private static GenericHttpMessageConverter<Object> getJsonMessageConverter() {
            if (jacksonPresent) {
                return new GenericHttpMessageConverterAdapter<Object>((SmartHttpMessageConverter<Object>)new JacksonJsonHttpMessageConverter());
            }
            if (jackson2Present) {
                return new MappingJackson2HttpMessageConverter();
            }
            if (gsonPresent) {
                return new GsonHttpMessageConverter();
            }
            if (jsonbPresent) {
                return new JsonbHttpMessageConverter();
            }
            return null;
        }

        static {
            ClassLoader classLoader = HttpMessageConverters.class.getClassLoader();
            jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.json.JsonMapper", (ClassLoader)classLoader);
            jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
            gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
            jsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)classLoader);
        }
    }
}

