/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collections;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.util.Assert;

public class DPoPAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 5481690438914686216L;
    private final String accessToken;
    private final String dPoPProof;
    private final String method;
    private final String resourceUri;

    public DPoPAuthenticationToken(String accessToken, String dPoPProof, String method, String resourceUri) {
        super(Collections.emptyList());
        Assert.hasText((String)accessToken, (String)"accessToken cannot be empty");
        Assert.hasText((String)dPoPProof, (String)"dPoPProof cannot be empty");
        Assert.hasText((String)method, (String)"method cannot be empty");
        Assert.hasText((String)resourceUri, (String)"resourceUri cannot be empty");
        this.accessToken = accessToken;
        this.dPoPProof = dPoPProof;
        this.method = method;
        this.resourceUri = resourceUri;
    }

    public Object getPrincipal() {
        return this.getAccessToken();
    }

    public Object getCredentials() {
        return this.getAccessToken();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getDPoPProof() {
        return this.dPoPProof;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }
}

