/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.introspection;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospectionClaimAccessor;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class SpringReactiveOpaqueTokenIntrospector
implements ReactiveOpaqueTokenIntrospector {
    private static final String AUTHORITY_PREFIX = "SCOPE_";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final URI introspectionUri;
    private final WebClient webClient;
    private Converter<OAuth2TokenIntrospectionClaimAccessor, Mono<? extends OAuth2AuthenticatedPrincipal>> authenticationConverter = this::defaultAuthenticationConverter;

    public SpringReactiveOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be empty");
        Assert.hasText((String)clientId, (String)"clientId cannot be empty");
        Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = WebClient.builder().defaultHeaders(h -> h.setBasicAuth(clientId, clientSecret)).build();
    }

    public SpringReactiveOpaqueTokenIntrospector(String introspectionUri, WebClient webClient) {
        Assert.hasText((String)introspectionUri, (String)"introspectionUri cannot be null");
        Assert.notNull((Object)webClient, (String)"webClient cannot be null");
        this.introspectionUri = URI.create(introspectionUri);
        this.webClient = webClient;
    }

    @Override
    public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
        return Mono.just((Object)token).flatMap(this::makeRequest).flatMap(this::adaptToNimbusResponse).map(this::convertClaimsSet).flatMap(arg_0 -> this.authenticationConverter.convert(arg_0)).cast(OAuth2AuthenticatedPrincipal.class).onErrorMap(e -> !(e instanceof OAuth2IntrospectionException), this::onError);
    }

    private Mono<ClientResponse> makeRequest(String token) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.introspectionUri)).header("Accept", new String[]{"application/json"})).body((BodyInserter)BodyInserters.fromFormData((String)"token", (String)token)).exchange();
    }

    private Mono<Map<String, Object>> adaptToNimbusResponse(ClientResponse responseEntity) {
        if (responseEntity.statusCode() != HttpStatus.OK) {
            return responseEntity.bodyToFlux(DataBuffer.class).map(DataBufferUtils::release).then(Mono.error((Throwable)new OAuth2IntrospectionException("Introspection endpoint responded with " + responseEntity.statusCode())));
        }
        return responseEntity.bodyToMono(STRING_OBJECT_MAP).filter(body -> (Boolean)body.compute("active", (k, v) -> {
            if (v instanceof String) {
                return Boolean.parseBoolean((String)v);
            }
            if (v instanceof Boolean) {
                return v;
            }
            return false;
        })).switchIfEmpty(Mono.error(() -> new BadOpaqueTokenException("Provided token isn't active")));
    }

    private ArrayListFromStringClaimAccessor convertClaimsSet(Map<String, Object> claims) {
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(claims);
        converted.computeIfPresent("aud", (k, v) -> {
            if (v instanceof String) {
                return Collections.singletonList(v);
            }
            return v;
        });
        converted.computeIfPresent("client_id", (k, v) -> v.toString());
        converted.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("iss", (k, v) -> v.toString());
        converted.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
        converted.computeIfPresent("scope", (k, v) -> {
            Object object;
            if (v instanceof String) {
                String s = (String)v;
                object = new ArrayListFromString(s.split(" "));
            } else {
                object = v;
            }
            return object;
        });
        return () -> converted;
    }

    private OAuth2IntrospectionException onError(Throwable ex) {
        return new OAuth2IntrospectionException(ex.getMessage(), ex);
    }

    public void setAuthenticationConverter(Converter<OAuth2TokenIntrospectionClaimAccessor, Mono<? extends OAuth2AuthenticatedPrincipal>> authenticationConverter) {
        Assert.notNull(authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    private Mono<OAuth2IntrospectionAuthenticatedPrincipal> defaultAuthenticationConverter(OAuth2TokenIntrospectionClaimAccessor accessor) {
        Collection<GrantedAuthority> authorities = this.authorities(accessor.getScopes());
        return Mono.just((Object)new OAuth2IntrospectionAuthenticatedPrincipal(accessor.getClaims(), authorities));
    }

    private Collection<GrantedAuthority> authorities(List<String> scopes) {
        if (!(scopes instanceof ArrayListFromString)) {
            return Collections.emptyList();
        }
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String scope : scopes) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(AUTHORITY_PREFIX + scope));
        }
        return authorities;
    }

    private static interface ArrayListFromStringClaimAccessor
    extends OAuth2TokenIntrospectionClaimAccessor {
        default public List<String> getScopes() {
            Object value = this.getClaims().get("scope");
            if (value instanceof ArrayListFromString) {
                ArrayListFromString list = (ArrayListFromString)value;
                return list;
            }
            return super.getScopes();
        }
    }

    private static final class ArrayListFromString
    extends ArrayList<String> {
        ArrayListFromString(String ... elements) {
            super(Arrays.asList(elements));
        }
    }
}

