/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.security.oauth2.jwt.ReactiveRemoteJWKSource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReactiveJwtDecoderProviderConfigurationUtils {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};

    static <C extends SecurityContext> Mono<ConfigurableJWTProcessor<C>> addJWSAlgorithms(ReactiveRemoteJWKSource jwkSource, ConfigurableJWTProcessor<C> jwtProcessor) {
        JWSKeySelector selector = jwtProcessor.getJWSKeySelector();
        if (!(selector instanceof JWSVerificationKeySelector)) {
            return Mono.just(jwtProcessor);
        }
        JWKSource delegate = ((JWSVerificationKeySelector)selector).getJWKSource();
        return ReactiveJwtDecoderProviderConfigurationUtils.getJWSAlgorithms(jwkSource).map(algorithms -> new JWSVerificationKeySelector(algorithms, delegate)).map(replacement -> {
            jwtProcessor.setJWSKeySelector((JWSKeySelector)replacement);
            return jwtProcessor;
        });
    }

    static Mono<Set<JWSAlgorithm>> getJWSAlgorithms(ReactiveRemoteJWKSource jwkSource) {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).keyTypes(new KeyType[]{KeyType.RSA, KeyType.EC}).build();
        return jwkSource.get(new JWKSelector(jwkMatcher)).map(jwks -> {
            HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
            for (JWK jwk : jwks) {
                if (jwk.getAlgorithm() != null) {
                    JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)jwk.getAlgorithm().getName());
                    jwsAlgorithms.add(jwsAlgorithm);
                    continue;
                }
                if (jwk.getKeyType() == KeyType.RSA) {
                    jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.RSA);
                    continue;
                }
                if (jwk.getKeyType() != KeyType.EC) continue;
                jwsAlgorithms.addAll((Collection<JWSAlgorithm>)JWSAlgorithm.Family.EC);
            }
            Assert.notEmpty(jwsAlgorithms, (String)"Failed to find any algorithms from the JWK set");
            return jwsAlgorithms;
        }).onErrorMap(KeySourceException.class, IllegalStateException::new);
    }

    static Mono<Map<String, Object>> getConfigurationForIssuerLocation(String issuer, WebClient web) {
        return ReactiveJwtDecoderProviderConfigurationUtils.getConfiguration(issuer, web, ReactiveJwtDecoderProviderConfigurationUtils.oidc(issuer), ReactiveJwtDecoderProviderConfigurationUtils.oidcRfc8414(issuer), ReactiveJwtDecoderProviderConfigurationUtils.oauth(issuer));
    }

    static UriComponents oidc(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(uri.getPath() + OIDC_METADATA_PATH).build();
    }

    static UriComponents oidcRfc8414(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(OIDC_METADATA_PATH + uri.getPath()).build();
    }

    static UriComponents oauth(String issuer) {
        UriComponents uri = UriComponentsBuilder.fromUriString((String)issuer).build();
        return UriComponentsBuilder.newInstance().uriComponents(uri).replacePath(OAUTH_METADATA_PATH + uri.getPath()).build();
    }

    private static Mono<Map<String, Object>> getConfiguration(String issuer, WebClient web, UriComponents ... uris) {
        String errorMessage = "Unable to resolve the Configuration with the provided Issuer of \"" + issuer + "\"";
        return Flux.just((Object[])uris).concatMap(uri -> web.get().uri(uri.toUriString(), new Object[0]).retrieve().bodyToMono(STRING_OBJECT_MAP)).flatMap(configuration -> {
            if (configuration.get("jwks_uri") == null) {
                return Mono.error(() -> new IllegalArgumentException("The public JWK set URI must not be null"));
            }
            return Mono.just((Object)configuration);
        }).onErrorContinue(ex -> ex instanceof WebClientResponseException && ((WebClientResponseException)ex).getStatusCode().is4xxClientError(), (ex, object) -> {}).onErrorMap(RuntimeException.class, ex -> ex instanceof IllegalArgumentException ? ex : new IllegalArgumentException(errorMessage, (Throwable)ex)).next().switchIfEmpty(Mono.error(() -> new IllegalArgumentException(errorMessage)));
    }

    private ReactiveJwtDecoderProviderConfigurationUtils() {
    }
}

