/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URL;
import java.time.Instant;
import java.util.List;
import org.springframework.security.oauth2.core.ClaimAccessor;

public interface JwtClaimAccessor
extends ClaimAccessor {
    default public URL getIssuer() {
        return this.getClaimAsURL("iss");
    }

    default public String getSubject() {
        return this.getClaimAsString("sub");
    }

    default public List<String> getAudience() {
        return this.getClaimAsStringList("aud");
    }

    default public Instant getExpiresAt() {
        return this.getClaimAsInstant("exp");
    }

    default public Instant getNotBefore() {
        return this.getClaimAsInstant("nbf");
    }

    default public Instant getIssuedAt() {
        return this.getClaimAsInstant("iat");
    }

    default public String getId() {
        return this.getClaimAsString("jti");
    }
}

