/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.authentication.event;

import org.springframework.context.ApplicationEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.Assert;

public final class OidcUserRefreshedEvent
extends ApplicationEvent {
    private static final long serialVersionUID = 2657442604286019694L;
    private final OidcUser oldOidcUser;
    private final OidcUser newOidcUser;
    private final Authentication authentication;

    public OidcUserRefreshedEvent(OAuth2AccessTokenResponse accessTokenResponse, OidcUser oldOidcUser, OidcUser newOidcUser, Authentication authentication) {
        super((Object)accessTokenResponse);
        Assert.notNull((Object)oldOidcUser, (String)"oldOidcUser cannot be null");
        Assert.notNull((Object)newOidcUser, (String)"newOidcUser cannot be null");
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        this.oldOidcUser = oldOidcUser;
        this.newOidcUser = newOidcUser;
        this.authentication = authentication;
    }

    public OAuth2AccessTokenResponse getAccessTokenResponse() {
        return (OAuth2AccessTokenResponse)this.getSource();
    }

    public OidcUser getOldOidcUser() {
        return this.oldOidcUser;
    }

    public OidcUser getNewOidcUser() {
        return this.newOidcUser;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }
}

