/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.util.Collection;
import org.springframework.security.oauth2.client.endpoint.AbstractWebClientReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public final class WebClientReactiveRefreshTokenTokenResponseClient
extends AbstractWebClientReactiveOAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest> {
    @Override
    public Mono<OAuth2AccessTokenResponse> getTokenResponse(OAuth2RefreshTokenGrantRequest grantRequest) {
        return super.getTokenResponse(grantRequest).map(accessTokenResponse -> this.populateTokenResponse(grantRequest, (OAuth2AccessTokenResponse)accessTokenResponse));
    }

    private OAuth2AccessTokenResponse populateTokenResponse(OAuth2RefreshTokenGrantRequest grantRequest, OAuth2AccessTokenResponse accessTokenResponse) {
        if (!CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes()) && accessTokenResponse.getRefreshToken() != null) {
            return accessTokenResponse;
        }
        OAuth2AccessTokenResponse.Builder tokenResponseBuilder = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)accessTokenResponse);
        if (CollectionUtils.isEmpty((Collection)accessTokenResponse.getAccessToken().getScopes())) {
            tokenResponseBuilder.scopes(grantRequest.getAccessToken().getScopes());
        }
        if (accessTokenResponse.getRefreshToken() == null) {
            tokenResponseBuilder.refreshToken(grantRequest.getRefreshToken().getTokenValue());
        }
        return tokenResponseBuilder.build();
    }
}

