/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.oauth2.client.ClientAuthorizationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.ClientAttributes;
import org.springframework.security.oauth2.client.web.DefaultReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class ServerOAuth2AuthorizedClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final String OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME = OAuth2AuthorizedClient.class.getName();
    private static final String SERVER_WEB_EXCHANGE_ATTR_NAME = ServerWebExchange.class.getName();
    private static final AnonymousAuthenticationToken ANONYMOUS_USER_TOKEN = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
    private final Mono<Authentication> currentAuthenticationMono = ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)ANONYMOUS_USER_TOKEN);
    private final Mono<String> clientRegistrationIdMono = this.currentAuthenticationMono.filter(t -> this.defaultOAuth2AuthorizedClient && t instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).map(OAuth2AuthenticationToken::getAuthorizedClientRegistrationId);
    private final Mono<ServerWebExchange> currentServerWebExchangeMono = Mono.deferContextual(Mono::just).filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    private final ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
    private boolean defaultOAuth2AuthorizedClient;
    private String defaultClientRegistrationId;
    private ClientResponseHandler clientResponseHandler;

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        Assert.notNull((Object)authorizedClientManager, (String)"authorizedClientManager cannot be null");
        this.authorizedClientManager = authorizedClientManager;
        this.clientResponseHandler = (request, responseMono) -> responseMono;
    }

    public ServerOAuth2AuthorizedClientExchangeFilterFunction(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler = new RemoveAuthorizedClientReactiveOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, (ServerWebExchange)attributes.get(ServerWebExchange.class.getName())));
        this.authorizedClientManager = ServerOAuth2AuthorizedClientExchangeFilterFunction.createDefaultAuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository, authorizationFailureHandler);
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
    }

    private static ReactiveOAuth2AuthorizedClientManager createDefaultAuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository, ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        DefaultReactiveOAuth2AuthorizedClientManager authorizedClientManager = new DefaultReactiveOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizationFailureHandler(authorizationFailureHandler);
        return authorizedClientManager;
    }

    public static Consumer<Map<String, Object>> oauth2AuthorizedClient(OAuth2AuthorizedClient authorizedClient) {
        return attributes -> attributes.put(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME, authorizedClient);
    }

    private static OAuth2AuthorizedClient oauth2AuthorizedClient(ClientRequest request) {
        return (OAuth2AuthorizedClient)request.attributes().get(OAUTH2_AUTHORIZED_CLIENT_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> serverWebExchange(ServerWebExchange serverWebExchange) {
        return attributes -> attributes.put(SERVER_WEB_EXCHANGE_ATTR_NAME, serverWebExchange);
    }

    private static ServerWebExchange serverWebExchange(ClientRequest request) {
        return (ServerWebExchange)request.attributes().get(SERVER_WEB_EXCHANGE_ATTR_NAME);
    }

    public static Consumer<Map<String, Object>> clientRegistrationId(String clientRegistrationId) {
        return ClientAttributes.clientRegistrationId(clientRegistrationId);
    }

    private static String clientRegistrationId(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClient = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        if (authorizedClient != null) {
            return authorizedClient.getClientRegistration().getRegistrationId();
        }
        return ClientAttributes.resolveClientRegistrationId(request.attributes());
    }

    public void setDefaultOAuth2AuthorizedClient(boolean defaultOAuth2AuthorizedClient) {
        this.defaultOAuth2AuthorizedClient = defaultOAuth2AuthorizedClient;
    }

    public void setDefaultClientRegistrationId(String clientRegistrationId) {
        this.defaultClientRegistrationId = clientRegistrationId;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return this.authorizedClient(request).map(authorizedClient -> this.bearer(request, (OAuth2AuthorizedClient)authorizedClient)).flatMap(requestWithBearer -> this.exchangeAndHandleResponse((ClientRequest)requestWithBearer, next)).switchIfEmpty(Mono.defer(() -> this.exchangeAndHandleResponse(request, next)));
    }

    private Mono<ClientResponse> exchangeAndHandleResponse(ClientRequest request, ExchangeFunction next) {
        return next.exchange(request).transform(responseMono -> this.clientResponseHandler.handleResponse(request, (Mono<ClientResponse>)responseMono));
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(ClientRequest request) {
        OAuth2AuthorizedClient authorizedClientFromAttrs = ServerOAuth2AuthorizedClientExchangeFilterFunction.oauth2AuthorizedClient(request);
        return Mono.justOrEmpty((Object)authorizedClientFromAttrs).switchIfEmpty(Mono.defer(() -> this.authorizeRequest(request).flatMap(this.authorizedClientManager::authorize))).flatMap(authorizedClient -> this.reauthorizeRequest(request, (OAuth2AuthorizedClient)authorizedClient).flatMap(this.authorizedClientManager::authorize));
    }

    private Mono<OAuth2AuthorizeRequest> authorizeRequest(ClientRequest request) {
        Mono<String> clientRegistrationId = this.effectiveClientRegistrationId(request);
        Mono<Optional<ServerWebExchange>> serverWebExchange = this.effectiveServerWebExchange(request);
        return Mono.zip(clientRegistrationId, this.currentAuthenticationMono, serverWebExchange).map(t3 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withClientRegistrationId((String)t3.getT1()).principal((Authentication)t3.getT2());
            ((Optional)t3.getT3()).ifPresent(exchange -> builder.attribute(ServerWebExchange.class.getName(), exchange));
            return builder.build();
        });
    }

    private Mono<String> effectiveClientRegistrationId(ClientRequest request) {
        return Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.clientRegistrationId(request)).switchIfEmpty(Mono.justOrEmpty((Object)this.defaultClientRegistrationId)).switchIfEmpty(this.clientRegistrationIdMono);
    }

    private Mono<Optional<ServerWebExchange>> effectiveServerWebExchange(ClientRequest request) {
        return Mono.justOrEmpty((Object)ServerOAuth2AuthorizedClientExchangeFilterFunction.serverWebExchange(request)).switchIfEmpty(this.currentServerWebExchangeMono).map(Optional::of).defaultIfEmpty(Optional.empty());
    }

    private Mono<OAuth2AuthorizeRequest> reauthorizeRequest(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        Mono<Optional<ServerWebExchange>> serverWebExchange = this.effectiveServerWebExchange(request);
        return Mono.zip(this.currentAuthenticationMono, serverWebExchange).map(t2 -> {
            OAuth2AuthorizeRequest.Builder builder = OAuth2AuthorizeRequest.withAuthorizedClient(authorizedClient).principal((Authentication)t2.getT1());
            ((Optional)t2.getT2()).ifPresent(exchange -> builder.attribute(ServerWebExchange.class.getName(), exchange));
            return builder.build();
        });
    }

    private ClientRequest bearer(ClientRequest request, OAuth2AuthorizedClient authorizedClient) {
        return ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(authorizedClient.getAccessToken().getTokenValue())).build();
    }

    public void setAuthorizationFailureHandler(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.clientResponseHandler = new AuthorizationFailureForwarder(authorizationFailureHandler);
    }

    @FunctionalInterface
    private static interface ClientResponseHandler {
        public Mono<ClientResponse> handleResponse(ClientRequest var1, Mono<ClientResponse> var2);
    }

    private final class AuthorizationFailureForwarder
    implements ClientResponseHandler {
        private final Map<HttpStatusCode, String> httpStatusToOAuth2ErrorCodeMap;
        private final ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler;

        private AuthorizationFailureForwarder(ReactiveOAuth2AuthorizationFailureHandler authorizationFailureHandler) {
            Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
            this.authorizationFailureHandler = authorizationFailureHandler;
            HashMap<HttpStatus, String> httpStatusToOAuth2Error = new HashMap<HttpStatus, String>();
            httpStatusToOAuth2Error.put(HttpStatus.UNAUTHORIZED, "invalid_token");
            httpStatusToOAuth2Error.put(HttpStatus.FORBIDDEN, "insufficient_scope");
            this.httpStatusToOAuth2ErrorCodeMap = Collections.unmodifiableMap(httpStatusToOAuth2Error);
        }

        @Override
        public Mono<ClientResponse> handleResponse(ClientRequest request, Mono<ClientResponse> responseMono) {
            return responseMono.flatMap(response -> this.handleResponse(request, (ClientResponse)response).thenReturn(response)).onErrorResume(WebClientResponseException.class, e -> this.handleWebClientResponseException(request, (WebClientResponseException)e).then(Mono.error((Throwable)e))).onErrorResume(OAuth2AuthorizationException.class, e -> this.handleAuthorizationException(request, (OAuth2AuthorizationException)((Object)e)).then(Mono.error((Throwable)e)));
        }

        private Mono<Void> handleResponse(ClientRequest request, ClientResponse response) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(response)).flatMap(oauth2Error -> {
                Mono<Optional<ServerWebExchange>> serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
                Mono<String> clientRegistrationId = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveClientRegistrationId(request);
                return Mono.zip(ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, serverWebExchange, clientRegistrationId).flatMap(zipped -> this.handleAuthorizationFailure((Authentication)zipped.getT1(), (Optional)zipped.getT2(), new ClientAuthorizationException((OAuth2Error)oauth2Error, (String)zipped.getT3())));
            });
        }

        private OAuth2Error resolveErrorIfPossible(ClientResponse response) {
            String wwwAuthenticateHeader;
            Map<String, String> authParameters;
            if (!response.headers().header("WWW-Authenticate").isEmpty() && (authParameters = this.parseAuthParameters(wwwAuthenticateHeader = (String)response.headers().header("WWW-Authenticate").get(0))).containsKey("error")) {
                return new OAuth2Error(authParameters.get("error"), authParameters.get("error_description"), authParameters.get("error_uri"));
            }
            return this.resolveErrorIfPossible(response.statusCode());
        }

        private OAuth2Error resolveErrorIfPossible(HttpStatusCode statusCode) {
            if (this.httpStatusToOAuth2ErrorCodeMap.containsKey(statusCode)) {
                return new OAuth2Error(this.httpStatusToOAuth2ErrorCodeMap.get(statusCode), null, "https://tools.ietf.org/html/rfc6750#section-3.1");
            }
            return null;
        }

        private Map<String, String> parseAuthParameters(String wwwAuthenticateHeader) {
            return Stream.of(wwwAuthenticateHeader).filter(header -> StringUtils.hasLength((String)header)).filter(header -> header.toLowerCase(Locale.ENGLISH).startsWith("bearer")).map(header -> header.substring("bearer".length())).map(header -> header.split(",")).flatMap(Stream::of).map(parameter -> parameter.split("=")).filter(parameter -> ((String[])parameter).length > 1).collect(Collectors.toMap(parameters -> parameters[0].trim(), parameters -> parameters[1].trim().replace("\"", "")));
        }

        private Mono<Void> handleWebClientResponseException(ClientRequest request, WebClientResponseException exception) {
            return Mono.justOrEmpty((Object)this.resolveErrorIfPossible(exception.getStatusCode())).flatMap(oauth2Error -> {
                Mono<Optional<ServerWebExchange>> serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
                Mono<String> clientRegistrationId = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveClientRegistrationId(request);
                return Mono.zip(ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, serverWebExchange, clientRegistrationId).flatMap(zipped -> this.handleAuthorizationFailure((Authentication)zipped.getT1(), (Optional)zipped.getT2(), new ClientAuthorizationException((OAuth2Error)oauth2Error, (String)zipped.getT3(), (Throwable)exception)));
            });
        }

        private Mono<Void> handleAuthorizationException(ClientRequest request, OAuth2AuthorizationException exception) {
            Mono<Optional<ServerWebExchange>> serverWebExchange = ServerOAuth2AuthorizedClientExchangeFilterFunction.this.effectiveServerWebExchange(request);
            return Mono.zip(ServerOAuth2AuthorizedClientExchangeFilterFunction.this.currentAuthenticationMono, serverWebExchange).flatMap(zipped -> this.handleAuthorizationFailure((Authentication)zipped.getT1(), (Optional)zipped.getT2(), exception));
        }

        private Mono<Void> handleAuthorizationFailure(Authentication principal, Optional<ServerWebExchange> exchange, OAuth2AuthorizationException exception) {
            return this.authorizationFailureHandler.onAuthorizationFailure(exception, principal, this.createAttributes(exchange.orElse(null)));
        }

        private Map<String, Object> createAttributes(ServerWebExchange exchange) {
            if (exchange == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(ServerWebExchange.class.getName(), exchange);
        }
    }
}

